/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.download.rmi;

import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPluginEnumeratorImpl;
import eu.dnetlib.data.download.rmi.DownloadService;
import eu.dnetlib.data.download.rmi.DownloadServiceException;
import eu.dnetlib.data.download.rmi.DownloadServiceFeeder;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class DownloadServiceImpl
extends AbstractBaseService
implements DownloadService {
    private static final Log log = LogFactory.getLog(DownloadServiceImpl.class);
    public static final DownloadItem END_QUEUE = new DownloadItem();
    @Resource
    private DownloadServiceFeeder downloadfeeder;
    @Resource
    DownloadPluginEnumeratorImpl downloadPluginEnumerator;
    private NotificationHandler notificationHandler;

    public void downloadFromResultSet(W3CEndpointReference resultSet, String plugin, String objectStoreID, String protocol, String mimeType) throws DownloadServiceException {
        new String();
        log.info((Object)String.format("Try to download using plugin %s , protocol : %s into ObjectStore id %s  ", plugin, protocol, objectStoreID));
        this.downloadfeeder.Download(resultSet.toString(), plugin, objectStoreID, protocol, mimeType, 5);
        log.info((Object)String.format("Completed Download", plugin, protocol, objectStoreID));
    }

    public void notify(String subscriptionId, String topic, String isId, String message) {
        this.getNotificationHandler().notified(subscriptionId, topic, isId, message);
    }

    public DownloadServiceFeeder getDownloadfeeder() {
        return this.downloadfeeder;
    }

    public void setDownloadfeeder(DownloadServiceFeeder downloadfeeder) {
        this.downloadfeeder = downloadfeeder;
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    @Required
    public void setNotificationHandler(NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    public List<String> listPlugins() throws DownloadServiceException {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.downloadPluginEnumerator.getAll().keySet());
        return result;
    }
}

