package eu.dnetlib.data.download.rmi;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class DownloadAction implements BlackboardServerAction<DownloadServiceActions> {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(DownloadAction.class);

	@Resource
	DownloadServiceFeeder downloadServiceFeeder;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {

		String epr = job.getParameters().get("epr");
		String plugin = job.getParameters().get("plugin");
		String objectStoreID = job.getParameters().get("objectStoreID");
		String protocol = job.getParameters().get("protocol");
		String mimeType = job.getParameters().get("mimeType");
		String numberOfThreads = job.getParameters().get("thread");
		if ((numberOfThreads == "") || (numberOfThreads == null)) {
			numberOfThreads = "5";
		}
		log.info(String.format("Try to download using plugin %s , protocol : %s into ObjectStore id %s  ", plugin, protocol, objectStoreID));
		downloadServiceFeeder.Download(epr, plugin, objectStoreID, protocol, mimeType, Integer.parseInt(numberOfThreads));
		log.info(String.format("Completed Download", plugin, protocol, objectStoreID));
		handler.done(job);
	}

}
