/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.download.rmi;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadPluginEnumeratorImpl;
import eu.dnetlib.data.download.rmi.DownloadServiceException;
import eu.dnetlib.data.download.rmi.DownloadServiceImpl;
import eu.dnetlib.data.download.worker.DownloadWorker;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStore;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStoreDao;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import java.util.concurrent.ArrayBlockingQueue;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DownloadServiceFeeder {
    private static final Log log = LogFactory.getLog(DownloadServiceFeeder.class);
    @Resource
    DownloadPluginEnumeratorImpl downloadPluginEnumerator;
    @Resource
    private ResultSetClientFactory resultSetClientFactory;
    @Autowired
    private ObjectStoreDao objectStoreDao;

    public void Download(String epr, String plugin, String objectStoreID, String protocol, String mimeType, int numberOfThreads) throws DownloadServiceException {
        final DownloadPlugin downloadPlugin = this.downloadPluginEnumerator.get(plugin);
        IterableResultSetClient urlInfo = this.resultSetClientFactory.getClient(epr);
        ArrayBlockingQueue<DownloadItem> itmesQueue = new ArrayBlockingQueue<DownloadItem>(1024);
        Iterable convertedUrl = Iterables.transform((Iterable)urlInfo, (Function)new Function<String, DownloadItem>(){

            public DownloadItem apply(String input) {
                DownloadItem di = DownloadItem.newObjectfromJSON((String)input);
                if (downloadPlugin.retrieveUrl(di) == null) {
                    di.setUrl(null);
                    di.setOriginalUrl(null);
                }
                return di;
            }
        });
        DownloadWorker[] workers = new DownloadWorker[numberOfThreads];
        ObjectStore objStore = this.objectStoreDao.getObjectStore(objectStoreID);
        for (int i = 0; i < numberOfThreads; ++i) {
            workers[i] = new DownloadWorker(itmesQueue, objStore, Protocols.valueOf((String)protocol), mimeType);
            new Thread(workers[i]).start();
        }
        for (DownloadItem di : convertedUrl) {
            try {
                itmesQueue.put(di);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
        }
        try {
            itmesQueue.put(DownloadServiceImpl.END_QUEUE);
        }
        catch (InterruptedException e) {
            log.error((Object)e);
        }
    }
}

