/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.download.rmi;

import com.google.common.collect.Maps;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadPluginEnumerator;
import eu.dnetlib.data.download.rmi.DownloadServiceException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;

public class DownloadPluginEnumeratorImpl
implements DownloadPluginEnumerator {
    private ListableBeanFactory beanFactory;

    public Map<String, DownloadPlugin> getAll() {
        return this.beanFactory.getBeansOfType(DownloadPlugin.class);
    }

    public Map<String, DownloadPlugin> getByProtocols() {
        HashMap res = Maps.newHashMap();
        for (DownloadPlugin cp : this.getAll().values()) {
            res.put(cp.getPluginName().toLowerCase(), cp);
        }
        return res;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public ListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public DownloadPlugin get(String protocol) throws DownloadServiceException {
        DownloadPlugin plugin = this.getByProtocols().get(protocol.toLowerCase());
        if (plugin == null) {
            throw new DownloadServiceException("plugin not found for name: " + protocol);
        }
        return plugin;
    }
}

