/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.dedup;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.hadoop.SubmitHadoopJobNode;
import java.util.List;
import java.util.Queue;
import javax.annotation.Resource;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public abstract class DedupConfigurationLoaderHadoopJobNode
extends SubmitHadoopJobNode {
    private static final Log log = LogFactory.getLog(DedupConfigurationLoaderHadoopJobNode.class);
    @Resource
    private UniqueServiceLocator serviceLocator;
    private String dedupConfigSequenceParam;
    private StringTemplate xqueryPace;
    private StringTemplate xqueryWf;

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        super.prepareJob(job, token);
        String entityType = this.getEntityType(token);
        Queue<String> dedupConfigurations = this.dedupConfigurations(token);
        String currentConf = dedupConfigurations.peek();
        log.info((Object)("using dedup configuration: '" + currentConf + "'"));
        String paceConf = this.loadPaceConf(entityType, currentConf);
        String wfConf = this.loadWfConf(entityType, currentConf);
        job.getParameters().put("dedup.pace.conf", paceConf);
        job.getParameters().put("dedup.wf.conf", wfConf);
        token.getEnv().setAttribute("dedup.pace.conf", paceConf);
        token.getEnv().setAttribute("dedup.wf.conf", wfConf);
        token.getEnv().setAttribute(this.getDedupConfigSequenceParam(), Joiner.on((String)":").skipNulls().join(dedupConfigurations));
    }

    protected Queue<String> dedupConfigurations(NodeToken token) {
        String configs = token.getFullEnv().getAttribute(this.getDedupConfigSequenceParam());
        if (configs == null) {
            throw new IllegalStateException("Cannot find dedup configurations in workflow env: '" + this.getDedupConfigSequenceParam() + "'");
        }
        if (configs.trim().isEmpty()) {
            return Queues.newLinkedBlockingQueue();
        }
        return Lists.newLinkedList((Iterable)Splitter.on((String)":").omitEmptyStrings().split((CharSequence)configs));
    }

    protected String getEntityType(NodeToken token) {
        String entityType = token.getEnv().getAttribute("entityType");
        if (StringUtils.isBlank((String)entityType)) {
            throw new IllegalStateException("Cannot find 'entityType' parameter in workflow env.");
        }
        return entityType;
    }

    protected String loadPaceConf(String entityType, String conf) throws ISLookUpException {
        return this.loadConfig(this.getXquery(entityType, conf, this.getXqueryPace()));
    }

    protected String loadWfConf(String entityType, String conf) throws ISLookUpException {
        return this.loadConfig(this.getXquery(entityType, conf, this.getXqueryWf()));
    }

    private String loadConfig(String xquery) throws ISLookUpException {
        log.info((Object)("loading configuration: " + xquery));
        List profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery);
        if (profile == null || profile.isEmpty()) {
            throw new IllegalStateException("unable to load dedup configuration profile");
        }
        String conf = (String)Iterables.getOnlyElement((Iterable)profile);
        return conf.replaceAll("\\s+", " ").trim();
    }

    private String getXquery(String entityType, String code, StringTemplate template) {
        StringTemplate xquery = new StringTemplate(template.getTemplate());
        xquery.setAttribute("entityType", (Object)entityType);
        xquery.setAttribute("configCode", (Object)code);
        return xquery.toString();
    }

    public StringTemplate getXqueryPace() {
        return this.xqueryPace;
    }

    @Required
    public void setXqueryPace(StringTemplate xqueryPace) {
        this.xqueryPace = xqueryPace;
    }

    public StringTemplate getXqueryWf() {
        return this.xqueryWf;
    }

    @Required
    public void setXqueryWf(StringTemplate xqueryWf) {
        this.xqueryWf = xqueryWf;
    }

    public String getDedupConfigSequenceParam() {
        return this.dedupConfigSequenceParam;
    }

    public void setDedupConfigSequenceParam(String dedupConfigSequenceParam) {
        this.dedupConfigSequenceParam = dedupConfigSequenceParam;
    }
}

