/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.dedup;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.proto.DedupSimilarityProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.dedup.DedupConfigurationLoaderHadoopJobNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DedupSimilarityToActionsJobNode
extends DedupConfigurationLoaderHadoopJobNode {
    private static final Log log = LogFactory.getLog(DedupSimilarityToActionsJobNode.class);

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        super.prepareJob(job, token);
        String entityType = token.getEnv().getAttribute("entityType");
        if (StringUtils.isBlank((String)entityType)) {
            throw new MSROException("unable to find wf param: entityType");
        }
        String cf = "_" + RelTypeProtos.SubRelType.dedupSimilarity + "_" + DedupSimilarityProtos.DedupSimilarity.RelName.isSimilarTo;
        switch (TypeProtos.Type.valueOf((String)entityType)) {
            case organization: {
                cf = RelTypeProtos.RelType.organizationOrganization + cf;
                break;
            }
            case person: {
                cf = RelTypeProtos.RelType.personPerson + cf;
                break;
            }
            case result: {
                cf = RelTypeProtos.RelType.resultResult + cf;
                break;
            }
            default: {
                throw new MSROException("invalid parameter entityType: " + entityType);
            }
        }
        log.info((Object)("using similarity CF: " + cf));
        job.getParameters().put("similarityCF", cf);
        token.getEnv().setAttribute("similarityCF", cf);
    }
}

