/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.dedup;

import com.google.common.base.Joiner;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.dedup.DedupConfigurationLoaderHadoopJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import java.util.Queue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DedupDuplicateScanJobNode
extends DedupConfigurationLoaderHadoopJobNode {
    private static final Log log = LogFactory.getLog(DedupDuplicateScanJobNode.class);

    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, NodeToken token) {
        return new DedupBlackboardWorkflowJobListener(engine, token);
    }

    private class DedupBlackboardWorkflowJobListener
    extends BlackboardWorkflowJobListener {
        public DedupBlackboardWorkflowJobListener(Engine engine, NodeToken token) {
            super(engine, token);
        }

        protected void onDone(BlackboardJob job) {
            Queue<String> confs = DedupDuplicateScanJobNode.this.dedupConfigurations(this.getToken());
            confs.poll();
            log.info((Object)("checking dedup configs queue, size: " + confs.size() + " configs: " + confs));
            if (CollectionUtils.isEmpty(confs)) {
                log.info((Object)"dedup similarity scan done");
                super.complete(job, "done");
            } else {
                log.info((Object)("remaining confs: " + confs));
                this.getToken().getEnv().setAttribute(DedupDuplicateScanJobNode.this.getDedupConfigSequenceParam(), Joiner.on((String)":").skipNulls().join(confs));
                super.complete(job, Arc.DEFAULT_ARC);
            }
        }
    }
}

