/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.dedup;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.functionality.modular.ui.dedup.EntityType;
import eu.dnetlib.functionality.modular.ui.dedup.SimilarityGroup;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class SimilarityGroupFunction
implements Function<String, SimilarityGroup> {
    public SimilarityGroup apply(String s) {
        try {
            Document d = new SAXReader().read((Reader)new StringReader(s));
            String groupid = d.valueOf("//FIELD[@name = 'id']");
            String date = d.valueOf("//FIELD[@name = 'date']");
            String type = d.valueOf("//FIELD[@name = 'entitytype']");
            TypeProtos.Type pType = TypeProtos.Type.valueOf((String)type);
            EntityType entityType = new EntityType(String.valueOf(pType.getNumber()), pType.toString(), this.label(pType.toString()));
            SimilarityGroup simEntry = new SimilarityGroup(groupid, date, entityType);
            List items = d.selectNodes("//FIELD[@name='group']/ITEM");
            HashSet group = Sets.newHashSet();
            for (Object id : items) {
                String objid = ((Node)id).getText();
                group.add(objid);
            }
            simEntry.setGroup(group);
            return simEntry;
        }
        catch (DocumentException e) {
            throw new RuntimeException("invalid xml: " + s);
        }
    }

    private String label(String s) {
        if (s.equals("result")) {
            return "Publication";
        }
        if (s.equals("organization")) {
            return "Organization";
        }
        return "Unknown";
    }
}

