/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.datasource.common.utils;

import com.google.common.collect.Maps;
import eu.dnetlib.datasource.common.utils.DatasourceUpdater;
import eu.dnetlib.datasource.common.utils.DatasourceUpdaterException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

@Deprecated
public class DefaultDatasourceUpdater
implements DatasourceUpdater {
    public static final String OVERRIDING_COMPLIANCE_FIELD = "overriding_compliance";
    private static final Log log = LogFactory.getLog(DefaultDatasourceUpdater.class);
    private static final String REPOSITORY_RESOURCE_TYPE = "RepositoryServiceResourceType";
    @Resource
    private UniqueServiceLocator serviceLocator;

    @Override
    public boolean updateApiExtraFields(String repoId, String ifaceId, Map<String, String> fields) throws DatasourceUpdaterException {
        try {
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(repoId);
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(profile));
            Element iface = (Element)doc.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']");
            if (iface != null) {
                while (iface.selectNodes("./INTERFACE_EXTRA_FIELD").size() > 0) {
                    iface.selectSingleNode("./INTERFACE_EXTRA_FIELD").detach();
                }
                for (Map.Entry<String, String> e : fields.entrySet()) {
                    if (e.getValue() == null || e.getValue().isEmpty()) continue;
                    Element field = iface.addElement("INTERFACE_EXTRA_FIELD");
                    field.addAttribute("name", e.getKey());
                    field.addText(e.getValue());
                }
            } else {
                log.error((Object)("Invalid interface: " + ifaceId));
                throw new DatasourceUpdaterException("Missing interface: " + ifaceId);
            }
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfile(repoId, doc.asXML(), REPOSITORY_RESOURCE_TYPE);
        }
        catch (Exception e) {
            log.error((Object)("Error updating API of profile: " + repoId));
            throw new DatasourceUpdaterException("Error updating API of profile: " + repoId, e);
        }
        return true;
    }

    @Override
    public boolean updateApiAccessParams(String repoId, String ifaceId, Map<String, String> params) throws DatasourceUpdaterException {
        try {
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(repoId);
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(profile));
            Element accessNode = (Element)doc.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']/ACCESS_PROTOCOL");
            if (accessNode != null) {
                while (accessNode.attributes().size() > 0) {
                    accessNode.selectSingleNode("@*").detach();
                }
                for (Map.Entry<String, String> e : params.entrySet()) {
                    if (e.getValue() == null || e.getValue().isEmpty()) continue;
                    if (e.getKey().equalsIgnoreCase("baseUrl")) {
                        doc.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']/BASE_URL").setText(e.getValue());
                        continue;
                    }
                    accessNode.addAttribute(e.getKey(), e.getValue());
                }
            } else {
                log.error((Object)("Invalid interface: " + ifaceId));
                throw new DatasourceUpdaterException("Missing interface: " + ifaceId);
            }
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfile(repoId, doc.asXML(), REPOSITORY_RESOURCE_TYPE);
        }
        catch (Exception e) {
            log.error((Object)("Error updating API of profile: " + repoId));
            throw new DatasourceUpdaterException("Error updating API of profile: " + repoId, e);
        }
        return true;
    }

    @Override
    public boolean overrideCompliance(String repoId, String ifaceId, String compliance) throws DatasourceUpdaterException {
        try {
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(repoId);
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(profile));
            Element iface = (Element)doc.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']");
            if (iface != null) {
                HashMap fields = Maps.newHashMap();
                if (!StringUtils.isEmpty((String)compliance)) {
                    fields.put(OVERRIDING_COMPLIANCE_FIELD, compliance);
                }
                while (iface.selectNodes("./INTERFACE_EXTRA_FIELD").size() > 0) {
                    Node node = iface.selectSingleNode("./INTERFACE_EXTRA_FIELD");
                    String name = node.valueOf("@name");
                    if (!name.equals(OVERRIDING_COMPLIANCE_FIELD)) {
                        fields.put(node.valueOf("@name"), node.getText());
                    }
                    node.detach();
                }
                for (Map.Entry e : fields.entrySet()) {
                    if (e.getValue() == null || ((String)e.getValue()).isEmpty()) continue;
                    Element field = iface.addElement("INTERFACE_EXTRA_FIELD");
                    field.addAttribute("name", (String)e.getKey());
                    field.addText((String)e.getValue());
                }
            } else {
                log.error((Object)("Invalid interface: " + ifaceId));
                throw new DatasourceUpdaterException("Missing interface: " + ifaceId);
            }
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfile(repoId, doc.asXML(), REPOSITORY_RESOURCE_TYPE);
        }
        catch (Exception e) {
            log.error((Object)("Error updating API of profile: " + repoId));
            throw new DatasourceUpdaterException("Error updating API of profile: " + repoId, e);
        }
        return true;
    }
}

