package eu.dnetlib.data.provision.index.rmi;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import eu.dnetlib.common.rmi.BaseService;

/**
 * Interface for the IndexService.
 * 
 * @author alessia
 * 
 */
@WebService(targetNamespace = "http://services.dnetlib.eu/")
public interface IndexService extends BaseService {

	/**
	 * Searches records matching the given CQL query in the index for the given metadata format, layout and interpretation.
	 * <p>
	 * If ixId is equals ignore case ALL, then the search is performed on all virtual indices. Otherwise the search is performed only the
	 * virtual index with the given identifier.
	 * </p>
	 * 
	 * @param ixId
	 *            identifier of the virtual index, or ALL.
	 * @param query
	 *            CQL query
	 * @param mdformat
	 *            format of the target index
	 * @param layout
	 *            layout of the target index
	 * @param interpretation
	 *            interpretation of the target index
	 * @return an endpoint to the ResultSet containing the matching records.
	 * @throws IndexServiceException
	 */
	@WebMethod(operationName = "lookup", action = "lookup")
	public W3CEndpointReference lookup(@WebParam(name = "id") final String ixId,
			@WebParam(name = "query") final String query,
			@WebParam(name = "mdformat") final String mdformat,
			@WebParam(name = "layout") final String layout,
			@WebParam(name = "interpretation") final String interpretation) throws IndexServiceException;

	/**
	 * 
	 * Searches records matching the given CQL query in the index for the given metadata format, layout and interpretation.
	 * 
	 * @param query
	 *            CQL query
	 * @param mdformat
	 *            format of the target index
	 * @param layout
	 *            layout of the target index
	 * @param interpretation
	 *            interpretation of the target index
	 * @return an endpoint to the ResultSet containing the matching records.
	 * @throws IndexServiceException
	 */
	@WebMethod(operationName = "lookupAll", action = "lookupAll")
	public W3CEndpointReference lookup(@WebParam(name = "query") final String query,
			@WebParam(name = "mdformat") final String mdformat,
			@WebParam(name = "layout") final String layout,
			@WebParam(name = "interpretation") final String interpretation) throws IndexServiceException;

	/**
	 * Browses the index with the given metadata format, layout and interpretation according to the given CQL query.
	 * <p>
	 * If ixId is equals ignore case ALL, then the browse is performed on all virtual indices. Otherwise the browse is performed only in the
	 * virtual index with the given identifier.
	 * </p>
	 * 
	 * @param ixId
	 *            identifier of the virtual index, or ALL.
	 * @param query
	 *            CQL query
	 * @param mdformat
	 *            format of the target index
	 * @param layout
	 *            layout of the target index
	 * @param interpretation
	 *            interpretation of the target index
	 * @throws IndexServiceException
	 * @return an endpoint to a ResultSet with the browsing results.
	 */
	@WebMethod(operationName = "browse", action = "browse")
	public W3CEndpointReference browse(@WebParam(name = "index") final String ixId,
			@WebParam(name = "query") final String query,
			@WebParam(name = "mdformat") final String mdFormat,
			@WebParam(name = "layout") final String layout,
			@WebParam(name = "interpretation") final String interpretation) throws IndexServiceException;

	/**
	 * Browses the index with the given metadata format, layout and interpretation according to the given CQL query.
	 * 
	 * @param query
	 *            CQL query
	 * @param mdformat
	 *            format of the target index
	 * @param layout
	 *            layout of the target index
	 * @param interpretation
	 *            interpretation of the target index
	 * 
	 * @throws IndexServiceException
	 * @return an endpoint to a ResultSet with the browsing results.
	 */
	@WebMethod(operationName = "browseAll", action = "browseAll")
	public W3CEndpointReference browse(@WebParam(name = "query") final String query,
			@WebParam(name = "mdformat") final String mdFormat,
			@WebParam(name = "layout") final String layout,
			@WebParam(name = "interpretation") final String interpretation) throws IndexServiceException;

	@WebMethod(operationName = "getIndexFiles", action = "getIndexFiles")
	public List<String> getIndexFiles(@WebParam(name = "mdformat") final String format,
			@WebParam(name = "layout") final String layout,
			@WebParam(name = "interpretation") final String interpretation);

	/**
	 * Returns list of all stored indices.
	 * 
	 * @return list of all stored indices
	 */
	@WebMethod(operationName = "getListOfIndices", action = "getListOfIndices")
	public List<String> getListOfIndices();

	/**
	 * Returns list of all stored indices in CSV format.
	 * 
	 * @return list of all stored indices in CSV format
	 */
	@WebMethod(operationName = "getListOfIndicesCSV", action = "getListOfIndicesCSV")
	public String getListOfIndicesCSV();
}
