package eu.dnetlib.data.collector.plugins.projects.gtr2;

import java.net.URL;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.*;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.CollectorServiceRuntimeException;
import eu.dnetlib.enabling.resultset.SizedIterable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

/**
 * Created by alessia on 28/11/16.
 */
public class Gtr2ProjectsIterable implements SizedIterable<String> {

	private static final Log log = LogFactory.getLog(Gtr2ProjectsIterable.class); // NOPMD
																					// by
																					// marko
																					// on
																					// 11/24/08
																					// 5:02
																					// PM

	public static final int PAGE_SZIE = 20;
	private String queryURL;
	private int total;
	private int maxPages;
	private int startFromPage = 0;
	private VTDGen vg;
	private VTDNav vn;
	private AutoPilot ap;
	private String namespaces;
	private boolean incremental = false;
	private DateTime fromDate;
	private DateTimeFormatter simpleDateTimeFormatter = DateTimeFormat.forPattern("yyyy-MM-dd");
	private ArrayBlockingQueue<String> projects = new ArrayBlockingQueue<String>(20);
	//private boolean finished = false;
	private final ExecutorService es = Executors.newFixedThreadPool(PAGE_SZIE);
	
	public Gtr2ProjectsIterable(final String baseUrl, final String fromDate) throws CollectorServiceException {
		queryURL = baseUrl + "/projects";
		vg = new VTDGen();
		this.incremental = StringUtils.isNotBlank(fromDate);
		if (incremental) {
			// I expect fromDate in the format 'yyyy-MM-dd'. See class
			// eu.dnetlib.msro.workflows.nodes.collect.FindDateRangeForIncrementalHarvestingJobNode
			// .
			this.fromDate = DateTime.parse(fromDate, simpleDateTimeFormatter);
			// log.debug("fromDate string: " + fromDate + " -- parsed: " +
			// this.fromDate.toString());
		}
		fillInfo();
	}

	@Override
	public int getNumberOfElements() {
		return total;
	}

	private void fillInfo() throws CollectorServiceException {
		try {
			// log.debug("Getting hit count from: " + queryURL);
			vg.parseHttpUrl(queryURL, false);
			initParser();
			String hitCount = vn.toNormalizedString(vn.getAttrVal("totalSize"));
			String totalPages = vn.toNormalizedString(vn.getAttrVal("totalPages"));
			namespaces = "xmlns:ns1=\"" + vn.toNormalizedString(vn.getAttrVal("ns1")) + "\" ";
			namespaces += "xmlns:ns2=\"" + vn.toNormalizedString(vn.getAttrVal("ns2")) + "\" ";
			namespaces += "xmlns:ns3=\"" + vn.toNormalizedString(vn.getAttrVal("ns3")) + "\" ";
			namespaces += "xmlns:ns4=\"" + vn.toNormalizedString(vn.getAttrVal("ns4")) + "\" ";
			namespaces += "xmlns:ns5=\"" + vn.toNormalizedString(vn.getAttrVal("ns5")) + "\" ";
			namespaces += "xmlns:ns6=\"" + vn.toNormalizedString(vn.getAttrVal("ns6")) + "\" ";
			total = Integer.parseInt(hitCount);
			maxPages = Integer.parseInt(totalPages);
			Thread ft = new Thread(new FillProjectList());
			ft.start();

			// log.debug("Expected number of pages: "+maxPages);
		} catch (NumberFormatException e) {
			// log.warn("Cannot set the total count or the number of pages");
		} catch (Throwable e) {
			throw new CollectorServiceException(e);
		}
	}

	@Override
	public Iterator<String> iterator() {
		return new Iterator<String>() {
			// The following is for debug only
			private int nextCounter = 0;

			@Override
			public boolean hasNext() {
				log.debug("finished " + es.isTerminated());
				log.debug("projects.isempty() " + projects.isEmpty());
				return !es.isTerminated() || !projects.isEmpty();
			}

			@Override
			public String next() {
				nextCounter++;
				log.debug(String.format("Calling next %s times. projects queue has %s elements", nextCounter,
						projects.size()));

				try {
					return projects.take();
				} catch (Exception e) {
					throw new CollectorServiceRuntimeException(e);
				}

			}

			@Override
			public void remove() {
				throw new UnsupportedOperationException();
			}

		};
	}

	private void initParser() {
		vn = vg.getNav();
		ap = new AutoPilot(vn);
	}

	public String getQueryURL() {
		return queryURL;
	}

	public void setQueryURL(final String queryURL) {
		this.queryURL = queryURL;
	}

	public int getTotal() {
		return total;
	}

	public void setTotal(final int total) {
		this.total = total;
	}

	public int getMaxPages() {
		return maxPages;
	}

	public void setMaxPages(final int maxPages) {
		this.maxPages = maxPages;
		log.debug("Overriding maxPages to " + maxPages);
	}

	public VTDGen getVg() {
		return vg;
	}

	public void setVg(final VTDGen vg) {
		this.vg = vg;
	}

	public VTDNav getVn() {
		return vn;
	}

	public void setVn(final VTDNav vn) {
		this.vn = vn;
	}

	public AutoPilot getAp() {
		return ap;
	}

	public void setAp(final AutoPilot ap) {
		this.ap = ap;
	}

	public String getNamespaces() {
		return namespaces;
	}

	public void setNamespaces(final String namespaces) {
		this.namespaces = namespaces;
	}

	public int getStartFromPage() {
		return startFromPage;
	}

	public void setStartFromPage(final int startFromPage) {
		this.startFromPage = startFromPage;
	}

	private class FillProjectList implements Runnable {
		private boolean morePages = true;
		private int pageNumber = startFromPage;

		@Override
		public void run() {
			
			try {
				do {
					String resultPage = getNextPage();
					if (StringUtils.isNotBlank(resultPage)) {
						// clear VGen before processing the next file
						vg.clear();
						//vg.setDoc(resultPage.getBytes());

						//vg.parse(false);
						vg.parseHttpUrl(resultPage, false);
						initParser();
						ap.selectXPath("//project");
						int res = -1;

						while ((res = ap.evalXPath()) != -1) {
							final String projectHref = vn.toNormalizedString(vn.getAttrVal("href"));
							Thread t = new Thread(new ParseProject(projectHref));
							t.setName("Thread for " + res);
							es.execute(t);
						}
						ap.resetXPath();

					}
					
				}while(morePages);
				es.shutdown();
				es.awaitTermination(10, TimeUnit.MINUTES);

			} catch (Throwable e) {
				log.debug("Eccezione in run" + e.getMessage());

			}
		}

		private String getNextPage() {
			try {
				pageNumber++;
				
				/*URL pageUrl = new URL(queryURL + "?p=" + pageNumber);
				log.info("Getting page at: " + pageUrl.toString());*/
				if (pageNumber == maxPages) {
					morePages = false;
				}
				log.debug(morePages);
				return queryURL + "?p=" + pageNumber;
				//return IOUtils.toString(pageUrl);
			} catch (Exception e) {
				throw new CollectorServiceRuntimeException("Error on page " + pageNumber, e);
			}
		}

	}

	private class ParseProject implements Runnable {

		VTDNav vn1;
		VTDGen vg1;
		private String projectRef;

		public ParseProject(final String projectHref) {
			projectRef = projectHref;
			vg1 = new VTDGen();
			vg1.parseHttpUrl(projectRef, false);
			vn1 = vg1.getNav();
		}

		private int projectsUpdate(String attr) throws CollectorServiceException {
			try {
				int index = vn1.getAttrVal(attr);
				if (index != -1) {
					String d = vn1.toNormalizedString(index);
					DateTime created = DateTime.parse(d.substring(0, d.indexOf("T")), simpleDateTimeFormatter);
					log.debug(attr + " Date string: " + created.toString() + " -- parsed: " + fromDate.toString());
					if (created.compareTo(fromDate) > 0) {// updated or created
															// after the last
															// time it was
															// collected
						log.debug("record collected ");
						return index;
					}
					return -1;
				}
				return index;
			} catch (Throwable e) {
				throw new CollectorServiceException(e);
			}
		}

		private String collectProject() throws CollectorServiceException {
			try {

				int p = vn1.getAttrVal("href");

				final String projectHref = vn1.toNormalizedString(p);
				log.debug("collecting project at " + projectHref);

				Gtr2Helper gtr2Helper = new Gtr2Helper();
				String projectPackage = gtr2Helper.processProject(vn1, namespaces);

				return projectPackage;
			} catch (Throwable e) {
				throw new CollectorServiceException(e);
			}
		}

		private boolean add(String attr) throws CollectorServiceException {
			int ret = -1;
			if ((ret = projectsUpdate(attr)) != -1)
				projects.add(collectProject());
			return (ret != -1);
		}

		@Override
		public void run() {
			log.debug("Getting project info from " + projectRef);
			// projects.add("PROJECT");
			try {
				if (incremental) {
					if (!add("created"))
						add("updated");
				} else
					projects.add(collectProject());
				log.debug("Project enqueued " + projectRef);
			} catch (Throwable e) {
				log.debug("Error on ParseProject " + e.getMessage());
				throw new CollectorServiceRuntimeException(e);
			}
		}

	}

}
