/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.projects.gtr2;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.collector.plugins.projects.gtr2.Gtr2Helper;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.CollectorServiceRuntimeException;
import eu.dnetlib.enabling.resultset.SizedIterable;
import java.net.URL;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class Gtr2ProjectsIterable
implements SizedIterable<String> {
    private static final Log log = LogFactory.getLog(Gtr2ProjectsIterable.class);
    public static final int PAGE_SZIE = 20;
    private String queryURL;
    private int total;
    private int maxPages;
    private int startFromPage = 0;
    private VTDGen vg;
    private VTDNav vn;
    private AutoPilot ap;
    private String namespaces;
    private boolean incremental = false;
    private DateTime fromDate;
    private DateTimeFormatter simpleDateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private Queue<String> projects = new ArrayBlockingQueue<String>(20);

    public Gtr2ProjectsIterable(String baseUrl, String fromDate) throws CollectorServiceException {
        this.queryURL = baseUrl + "/projects";
        this.vg = new VTDGen();
        this.incremental = StringUtils.isNotBlank((String)fromDate);
        if (this.incremental) {
            this.fromDate = DateTime.parse((String)fromDate, (DateTimeFormatter)this.simpleDateTimeFormatter);
        }
        this.fillInfo();
    }

    public int getNumberOfElements() {
        return this.total;
    }

    private void fillInfo() throws CollectorServiceException {
        try {
            this.vg.parseHttpUrl(this.queryURL, false);
            this.initParser();
            String hitCount = this.vn.toNormalizedString(this.vn.getAttrVal("totalSize"));
            String totalPages = this.vn.toNormalizedString(this.vn.getAttrVal("totalPages"));
            this.namespaces = "xmlns:ns1=\"" + this.vn.toNormalizedString(this.vn.getAttrVal("ns1")) + "\" ";
            this.namespaces = this.namespaces + "xmlns:ns2=\"" + this.vn.toNormalizedString(this.vn.getAttrVal("ns2")) + "\" ";
            this.namespaces = this.namespaces + "xmlns:ns3=\"" + this.vn.toNormalizedString(this.vn.getAttrVal("ns3")) + "\" ";
            this.namespaces = this.namespaces + "xmlns:ns4=\"" + this.vn.toNormalizedString(this.vn.getAttrVal("ns4")) + "\" ";
            this.namespaces = this.namespaces + "xmlns:ns5=\"" + this.vn.toNormalizedString(this.vn.getAttrVal("ns5")) + "\" ";
            this.namespaces = this.namespaces + "xmlns:ns6=\"" + this.vn.toNormalizedString(this.vn.getAttrVal("ns6")) + "\" ";
            this.total = Integer.parseInt(hitCount);
            this.maxPages = Integer.parseInt(totalPages);
        }
        catch (NumberFormatException e) {
        }
        catch (Throwable e) {
            throw new CollectorServiceException(e);
        }
    }

    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private boolean morePages = true;
            private int pageNumber = Gtr2ProjectsIterable.this.getStartFromPage();
            private int nextCounter = 0;

            @Override
            public boolean hasNext() {
                if (!Gtr2ProjectsIterable.this.incremental) {
                    return this.morePages || !Gtr2ProjectsIterable.this.projects.isEmpty();
                }
                try {
                    this.fillProjectListIfNeeded();
                }
                catch (CollectorServiceException e) {
                    throw new CollectorServiceRuntimeException((Throwable)e);
                }
                return !Gtr2ProjectsIterable.this.projects.isEmpty();
            }

            @Override
            public String next() {
                ++this.nextCounter;
                log.debug((Object)String.format("Calling next %s times. projects queue has %s elements", this.nextCounter, Gtr2ProjectsIterable.this.projects.size()));
                try {
                    this.fillProjectListIfNeeded();
                    return (String)Gtr2ProjectsIterable.this.projects.poll();
                }
                catch (CollectorServiceException e) {
                    throw new CollectorServiceRuntimeException((Throwable)e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void fillProjectListIfNeeded() throws CollectorServiceException {
                ExecutorService es = Executors.newFixedThreadPool(20);
                try {
                    if (Gtr2ProjectsIterable.this.projects.isEmpty()) {
                        do {
                            if (this.morePages) {
                                String resultPage = this.getNextPage();
                                if (!StringUtils.isNotBlank((String)resultPage)) continue;
                                Gtr2ProjectsIterable.this.vg.clear();
                                Gtr2ProjectsIterable.this.vg.setDoc(resultPage.getBytes());
                                Gtr2ProjectsIterable.this.vg.parse(false);
                                Gtr2ProjectsIterable.this.initParser();
                                Gtr2ProjectsIterable.this.ap.selectXPath("//project");
                                int res = -1;
                                while ((res = Gtr2ProjectsIterable.this.ap.evalXPath()) != -1) {
                                    String projectHref = Gtr2ProjectsIterable.this.vn.toNormalizedString(Gtr2ProjectsIterable.this.vn.getAttrVal("href"));
                                    Thread t = new Thread(new ParseProject(projectHref));
                                    t.setName("Thread for " + res);
                                    es.execute(t);
                                }
                                Gtr2ProjectsIterable.this.ap.resetXPath();
                                es.shutdown();
                                log.debug((Object)"Shutting down");
                                es.awaitTermination(10L, TimeUnit.MINUTES);
                                log.debug((Object)"Ok, thread ended");
                                continue;
                            }
                            log.debug((Object)"No more pages");
                        } while (Gtr2ProjectsIterable.this.projects.isEmpty() && this.morePages);
                        log.debug((Object)"Exiting while");
                    } else {
                        log.debug((Object)"Projects is not empty");
                    }
                }
                catch (Throwable e) {
                    log.debug((Object)("Eccezione in fillProjectListIfNeeded" + e.getMessage()));
                    throw new CollectorServiceException(e);
                }
            }

            private String getNextPage() {
                try {
                    ++this.pageNumber;
                    URL pageUrl = new URL(Gtr2ProjectsIterable.this.queryURL + "?p=" + this.pageNumber);
                    log.info((Object)("Getting page at: " + pageUrl.toString()));
                    if (this.pageNumber == Gtr2ProjectsIterable.this.maxPages) {
                        this.morePages = false;
                    }
                    return IOUtils.toString((URL)pageUrl);
                }
                catch (Exception e) {
                    throw new CollectorServiceRuntimeException("Error on page " + this.pageNumber, (Throwable)e);
                }
            }
        };
    }

    private void initParser() {
        this.vn = this.vg.getNav();
        this.ap = new AutoPilot(this.vn);
    }

    public String getQueryURL() {
        return this.queryURL;
    }

    public void setQueryURL(String queryURL) {
        this.queryURL = queryURL;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getMaxPages() {
        return this.maxPages;
    }

    public void setMaxPages(int maxPages) {
        this.maxPages = maxPages;
        log.debug((Object)("Overriding maxPages to " + maxPages));
    }

    public VTDGen getVg() {
        return this.vg;
    }

    public void setVg(VTDGen vg) {
        this.vg = vg;
    }

    public VTDNav getVn() {
        return this.vn;
    }

    public void setVn(VTDNav vn) {
        this.vn = vn;
    }

    public AutoPilot getAp() {
        return this.ap;
    }

    public void setAp(AutoPilot ap) {
        this.ap = ap;
    }

    public String getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(String namespaces) {
        this.namespaces = namespaces;
    }

    public int getStartFromPage() {
        return this.startFromPage;
    }

    public void setStartFromPage(int startFromPage) {
        this.startFromPage = startFromPage;
    }

    private class ParseProject
    implements Runnable {
        VTDNav vn1;
        VTDGen vg1;
        private String projectRef;

        public ParseProject(String projectHref) {
            this.projectRef = projectHref;
            this.vg1 = new VTDGen();
            this.vg1.parseHttpUrl(this.projectRef, false);
            this.vn1 = this.vg1.getNav();
        }

        private int projectsUpdate(String attr) throws CollectorServiceException {
            try {
                int index = this.vn1.getAttrVal(attr);
                if (index != -1) {
                    String d = this.vn1.toNormalizedString(index);
                    DateTime created = DateTime.parse((String)d.substring(0, d.indexOf("T")), (DateTimeFormatter)Gtr2ProjectsIterable.this.simpleDateTimeFormatter);
                    log.debug((Object)(attr + " Date string: " + created.toString() + " -- parsed: " + Gtr2ProjectsIterable.this.fromDate.toString()));
                    if (created.compareTo((ReadableInstant)Gtr2ProjectsIterable.this.fromDate) > 0) {
                        log.debug((Object)"record collected ");
                        return index;
                    }
                    return -1;
                }
                return index;
            }
            catch (Throwable e) {
                throw new CollectorServiceException(e);
            }
        }

        private String collectProject() throws CollectorServiceException {
            try {
                int p = this.vn1.getAttrVal("href");
                String projectHref = this.vn1.toNormalizedString(p);
                log.debug((Object)("collecting project at " + projectHref));
                Gtr2Helper gtr2Helper = new Gtr2Helper();
                String projectPackage = gtr2Helper.processProject(this.vn1, Gtr2ProjectsIterable.this.namespaces);
                return projectPackage;
            }
            catch (Throwable e) {
                throw new CollectorServiceException(e);
            }
        }

        private boolean add(String attr) throws CollectorServiceException {
            int ret = -1;
            ret = this.projectsUpdate(attr);
            if (ret != -1) {
                Gtr2ProjectsIterable.this.projects.add(this.collectProject());
            }
            return ret != -1;
        }

        @Override
        public void run() {
            log.debug((Object)("Getting project info from " + this.projectRef));
            try {
                if (Gtr2ProjectsIterable.this.incremental) {
                    if (!this.add("created")) {
                        this.add("updated");
                    }
                } else {
                    Gtr2ProjectsIterable.this.projects.add(this.collectProject());
                }
                log.debug((Object)("Project enqueued " + this.projectRef));
            }
            catch (Throwable e) {
                log.debug((Object)("Error on ParseProject " + e.getMessage()));
                throw new CollectorServiceRuntimeException(e);
            }
        }
    }
}

