/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.datasources;

import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.CollectorServiceRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Re3DataRepositoriesIterator
implements Iterator<String>,
Iterable<String> {
    private static final Log log = LogFactory.getLog(Re3DataRepositoriesIterator.class);
    private String baseURL;
    private XMLStreamReader reader;
    private int countedRepos = 0;
    private String currentRepoPath = null;

    @Override
    public boolean hasNext() {
        return this.currentRepoPath != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        if (this.currentRepoPath == null) {
            throw new NoSuchElementException();
        }
        try {
            String repoInfo;
            String string = repoInfo = this.getRepositoryInfo(this.currentRepoPath);
            return string;
        }
        finally {
            this.currentRepoPath = this.moveToNextRepo();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    public Re3DataRepositoriesIterator(InputStream xmlInputStream, String baseUrl) throws CollectorServiceException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            this.reader = factory.createXMLStreamReader(xmlInputStream);
        }
        catch (XMLStreamException e) {
            throw new CollectorServiceException((Throwable)e);
        }
        this.baseURL = baseUrl;
        this.currentRepoPath = this.moveToNextRepo();
    }

    private String getNextRepositoryPath() {
        return this.reader.getAttributeValue(null, "href");
    }

    private String moveToNextRepo() {
        try {
            while (this.reader.hasNext()) {
                String elementName;
                int event = this.reader.next();
                if (event != 1 || !(elementName = this.reader.getLocalName()).equals("link")) continue;
                String repoPath = this.getNextRepositoryPath();
                log.debug((Object)String.format("Found %s repositories. The last has link %s", ++this.countedRepos, repoPath));
                return repoPath;
            }
            log.info((Object)("Seems there are no more repository to iterate on. Total: " + this.countedRepos));
            return null;
        }
        catch (XMLStreamException e) {
            throw new CollectorServiceRuntimeException((Throwable)e);
        }
    }

    private String getRepositoryInfo(String repositoryPath) throws CollectorServiceRuntimeException {
        String targetURL = repositoryPath;
        if (!repositoryPath.startsWith(this.baseURL)) {
            targetURL = this.baseURL + repositoryPath;
        }
        try {
            return IOUtils.toString((URL)new URL(targetURL));
        }
        catch (IOException e) {
            throw new CollectorServiceRuntimeException("OOOPS something bad happen getting repo info from " + targetURL, (Throwable)e);
        }
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public int getCountedRepos() {
        return this.countedRepos;
    }

    public void setCountedRepos(int countedRepos) {
        this.countedRepos = countedRepos;
    }
}

