/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.actions;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.actionmanager.ActionManagerConstants;
import eu.dnetlib.actionmanager.actions.AbstractAction;
import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.hbase.HBasePutFactory;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;

public class XsltInfoPackageAction
extends AbstractAction {
    private static final Log log = LogFactory.getLog(XsltInfoPackageAction.class);
    private final List<Put> puts = Lists.newArrayList();
    private Operation operation;
    private String infoPackage;
    private Provenance provenance;
    private String nsprefix;
    private String trust;
    private ActionFactory actionFactory;
    private Transformer transformer;

    public XsltInfoPackageAction(String rawSet, Agent agent, Operation operation, String infoPackage, Provenance provenance, String nsprefix, String trust, Transformer transformer, ActionFactory actionFactory) {
        super(ActionManagerConstants.ACTION_TYPE.pkg, rawSet, agent);
        this.transformer = transformer;
        this.operation = operation;
        this.infoPackage = infoPackage;
        this.provenance = provenance;
        this.nsprefix = nsprefix;
        this.trust = trust;
        this.actionFactory = actionFactory;
        this.transformer = transformer;
    }

    public List<Put> asPutOperations() throws ActionManagerException {
        if (this.puts.isEmpty()) {
            try {
                for (AtomicAction action : this.calculateAtomicActions()) {
                    if (action == null || !action.isValid()) continue;
                    this.puts.addAll(action.asPutOperations(this.getRowKey(), this.provenance, this.trust, this.nsprefix));
                }
            }
            catch (Exception e) {
                log.error((Object)"Error generating actions", (Throwable)e);
                throw new ActionManagerException((Throwable)e);
            }
        }
        return this.puts;
    }

    public List<AtomicAction> asAtomicActions() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.calculateAtomicActions(), (Predicate)new Predicate<AtomicAction>(){

            public boolean apply(AtomicAction action) {
                return action != null && action.isValid();
            }
        }));
    }

    private Document applyXslt(String xml, Provenance provenance, String trust, String nsprefix) throws DocumentException, TransformerException {
        Document doc = new SAXReader().read((Reader)new StringReader(xml));
        DocumentResult result = new DocumentResult();
        this.transformer.setParameter("trust", trust);
        this.transformer.setParameter("provenance", provenance.toString());
        this.transformer.setParameter("namespaceprefix", nsprefix);
        this.transformer.transform((Source)new DocumentSource(doc), (Result)result);
        return result.getDocument();
    }

    protected List<AtomicAction> calculateAtomicActions() {
        ArrayList list = Lists.newArrayList();
        try {
            Document doc = this.applyXslt(this.getInfoPackage(), this.provenance, this.trust, this.nsprefix);
            for (Object o : doc.selectNodes("//ACTION")) {
                list.add(this.createAtomicAction((Element)o));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error generating actions", (Throwable)e);
        }
        return list;
    }

    private AtomicAction createAtomicAction(Element elem) {
        String key = elem.valueOf("./@targetKey");
        String colFamily = elem.valueOf("./@targetColumnFamily");
        String col = elem.valueOf("./@targetColumn");
        String value64 = elem.getTextTrim();
        byte[] value = value64.isEmpty() ? null : Base64.decodeBase64((String)value64);
        return this.getActionFactory().createAtomicAction(this.getRawSet(), this.getAgent(), key, colFamily, col, value);
    }

    private Put prepareMetaPut(List<String> partIds) {
        Put put = HBasePutFactory.createPutOperation(this.getRowKey(), this.getRawSet(), this.getAgent());
        put.add(ActionManagerConstants.OPERATION_COLFAMILY, Bytes.toBytes((String)this.getOperation().toString()), Bytes.toBytes((String)this.getOperation().toString()));
        put.add(ActionManagerConstants.ACTION_COLFAMILY, Bytes.toBytes((String)this.getActionType().toString()), this.getBytesContent(this.infoPackage));
        for (String id : partIds) {
            put.add(ActionManagerConstants.RELATION_COLFAMILY, Bytes.toBytes((String)id), ActionManagerConstants.HASPARTS);
        }
        return put;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public ActionFactory getActionFactory() {
        return this.actionFactory;
    }

    public void setActionFactory(ActionFactory actionFactory) {
        this.actionFactory = actionFactory;
    }

    protected byte[] getBytesContent(String content) {
        return Bytes.toBytes((String)content);
    }

    public String getInfoPackage() {
        return this.infoPackage;
    }

    public void setInfoPackage(String infoPackage) {
        this.infoPackage = infoPackage;
    }

    public Provenance getProvenance() {
        return this.provenance;
    }

    public void setProvenance(Provenance provenance) {
        this.provenance = provenance;
    }

    public String getTrust() {
        return this.trust;
    }

    public void setTrust(String trust) {
        this.trust = trust;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public String getNsprefix() {
        return this.nsprefix;
    }

    public void setNsprefix(String nsprefix) {
        this.nsprefix = nsprefix;
    }
}

