package eu.dnetlib.data.broker.model.openaire;

import com.google.gson.GsonBuilder;

/**
 * Created by claudio on 11/07/16.
 */
public class OpenAireEventPayload {

	private Publication publication;

	private Publication highlight;

	public OpenAireEventPayload() {}

	public Publication getPublication() {
		return publication;
	}

	public OpenAireEventPayload setPublication(final Publication publication) {
		this.publication = publication;
		return this;
	}

	public OpenAireEventPayload setHighlight(final Publication highlight) {
		this.highlight = highlight;
		return this;
	}

	public Publication getHighlight() {
		return highlight;
	}

	public static OpenAireEventPayload fromJSON(final String json) {
		final GsonBuilder b = new GsonBuilder();
		return b.create().fromJson(json, OpenAireEventPayload.class);
	}

	public String toJSON() {
		final GsonBuilder b = new GsonBuilder();
		return b.create().toJson(this);
	}

}
