package eu.dnetlib.data.hadoop.hbase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;

public class HBaseAdminFactory {

	private static final Log log = LogFactory.getLog(HBaseAdminFactory.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Autowired
	private ConfigurationEnumerator configurationEnumerator;

	public HBaseAdmin newInstance(ClusterName clusterName) throws HadoopServiceException {
		try {
			log.info("init hbaseAdmin, cluster: " + clusterName.toString());
			return new HBaseAdmin(configurationEnumerator.get(clusterName));
		} catch (MasterNotRunningException e) {
			throw new HadoopServiceException(e);
		} catch (ZooKeeperConnectionException e) {
			throw new HadoopServiceException(e);
		}
	}
}
