package eu.dnetlib.data.hadoop.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;

public class ImportEprHdfsAction extends AbstractHadoopAction {

	private static final Log log = LogFactory.getLog(ImportEprHdfsAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	private SequenceFileFeeder sequenceFileFeeder;

	@Override
	public void executeAsync(final BlackboardServerHandler handler, final BlackboardJob job) {
		try {

			final String epr = DnetXsltFunctions.decodeBase64(job.getParameters().get("input_epr"));
			final ClusterName clusterName = ClusterName.valueOf(job.getParameters().get("cluster"));
			final String path = job.getParameters().get("path");

			log.info("Starting import in hdfs sequence file: " + path);

			handler.ongoing(job);
			getSequenceFileFeeder().feed(epr, clusterName, path, new ImportEprActionCallback() {

				@Override
				public void done(int count) {
					log.info("Import completed successfully");
					job.getParameters().put("count", String.valueOf(count));
					handler.done(job);
				}

				@Override
				public void failed(final Throwable e) {
					log.error("Import failed", e);
					handler.failed(job, e);
				}
			});
		} catch (Throwable e) {
			log.error("Import failed", e);
			handler.failed(job, e);
		}
	}

	public SequenceFileFeeder getSequenceFileFeeder() {
		return sequenceFileFeeder;
	}

	@Required
	public void setSequenceFileFeeder(SequenceFileFeeder sequenceFileFeeder) {
		this.sequenceFileFeeder = sequenceFileFeeder;
	}

}
