package eu.dnetlib.data.hadoop.action;

import java.io.IOException;
import java.net.URI;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

/**
 * Delete a path on hdfs.
 * 
 * Params - cluster: cluster name, path: the path to delete recursively
 * 
 * @author claudio
 * 
 */
public class DeleteHdfsPathAction extends AbstractHadoopAction {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(DeleteHdfsPathAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Autowired
	protected ConfigurationEnumerator configurationEnumerator;

	@Override
	protected void executeAsync(BlackboardServerHandler handler, BlackboardJob job) {
		try {
			final ClusterName clusterName = ClusterName.valueOf(job.getParameters().get("cluster"));
			log.info("delete request on cluster: " + clusterName.toString());
			delete(job.getParameters().get("path"), configurationEnumerator.get(clusterName));

			handler.done(job);
		} catch (IOException e) {
			handler.failed(job, e);
		}
	}

	private void delete(final String path, Configuration conf) throws IOException {
		final FileSystem hdfs = FileSystem.get(conf);
		final Path absolutePath = new Path(URI.create(conf.get("fs.defaultFS") + path));

		if (hdfs.exists(absolutePath)) {
			log.debug("delete path: " + absolutePath.toString());
			hdfs.delete(absolutePath, true);
			log.info("deleted path: " + absolutePath.toString());
		} else {
			log.warn("cannot delete unexisting path: " + absolutePath.toString());
		}
	}

}
