package eu.dnetlib.data.hadoop;

import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.mapred.JobClient;
import org.apache.oozie.client.OozieClient;

public class HadoopClients {

	private final JobClient jtClient;

	private final OozieClient oozieClient;

	private final HBaseAdmin hbaseAdmin;

	public HadoopClients(JobClient jtClient, OozieClient oozieClient, HBaseAdmin hbaseAdmin) {
		super();
		this.jtClient = jtClient;
		this.oozieClient = oozieClient;
		this.hbaseAdmin = hbaseAdmin;
	}

	public JobClient getJtClient() {
		return jtClient;
	}

	public HBaseAdmin getHbaseAdmin() {
		return hbaseAdmin;
	}

	public OozieClient getOozieClient() {
		return oozieClient;
	}

	public boolean isOozieAvailable() {
		return getOozieClient() != null;
	}

	public boolean isHbaseAvailable() {
		return getHbaseAdmin() != null;
	}

	public boolean isMapredAvailable() {
		return getJtClient() != null;
	}

}
