/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.maven.plugin.oozie;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowJob;

public class CheckJobStatus
extends AbstractMojo {
    public static final String PROPERTY_NAME_LOG_FILE_LOCATION = "logFileLocation";
    private String oozieLocation;
    private String jobId;
    private Integer maxExecutionTimeMins;
    private Integer checkIntervalSecs = 5;

    public void execute() throws MojoExecutionException, MojoFailureException {
        OozieClient oozieClient = new OozieClient(this.oozieLocation);
        long maxExecutionTime = 60000L * (long)this.maxExecutionTimeMins.intValue();
        long checkInterval = 1000L * (long)this.checkIntervalSecs.intValue();
        long startTime = System.currentTimeMillis();
        try {
            try {
                while (System.currentTimeMillis() - startTime < maxExecutionTime) {
                    Thread.sleep(checkInterval);
                    WorkflowJob.Status status = oozieClient.getJobInfo(this.jobId).getStatus();
                    if (WorkflowJob.Status.SUCCEEDED.equals((Object)status)) {
                        this.getLog().info((CharSequence)"job SUCCEEDED");
                        return;
                    }
                    if (WorkflowJob.Status.FAILED.equals((Object)status) || WorkflowJob.Status.KILLED.equals((Object)status)) {
                        System.out.print(oozieClient.getJobLog(this.jobId));
                        throw new MojoFailureException("job " + this.jobId + " finished with status: " + status);
                    }
                    this.getLog().info((CharSequence)("job " + this.jobId + " is still running with status: " + status));
                }
                System.out.print(oozieClient.getJobLog(this.jobId));
                throw new MojoFailureException("Maximum execution time has passed!");
            }
            catch (InterruptedException e) {
                System.out.print(oozieClient.getJobLog(this.jobId));
                throw new MojoExecutionException("exception occured while sleeping", (Exception)e);
            }
        }
        catch (OozieClientException e) {
            throw new MojoExecutionException("exception occured when obtaining status from oozie", (Exception)((Object)e));
        }
    }
}

