var module = angular.module('statsUI', []);

module.directive('tooltip', function() {
	return {
		restrict : 'A',
		link : function(scope, element, attrs) {
			$(element).tooltip();
		}
	}
});

module.controller('statsCtrl', function ($scope, $http) {
	initSpinner();
	showSpinner();
	$http.get('ingestion_timeseries.json')
		.success(
			function(data) {
				$scope.stats = data;
				hideSpinner();
				new Morris.Line({
					  // ID of the element in which to draw the chart.
					  element: 'timePlot',
					  // Chart data records -- each entry in this array corresponds to a point on
					  // the chart.
					  data: $scope.stats,
					  // The name of the data record attribute that contains x-values.
					  xkey: 'label',
					  // A list of names of data record attributes that contain y-values.
					  ykeys: ['value'],
					  // Labels for the ykeys -- will be displayed when you hover over the
					  // chart.
					  labels: ['value']
					});
			})
		.error(
			function() {
				show_notification("error", "Something really bad must have happened to our fellow hamster..");
				hideSpinner();
			});
	
	$http.get('ingestion_donut.json')
	.success(
		function(data) {
			$scope.stats = data;
			hideSpinner();
			new Morris.Donut({
				  // ID of the element in which to draw the chart.
				  element: 'ingestionDonut',
				  // Chart data records -- each entry in this array corresponds to a point on
				  // the chart.
				  data: $scope.stats,
				});
		})
	.error(
		function() {
			show_notification("error", "Something really bad must have happened to our fellow hamster..");
			hideSpinner();
		});
	
	$http.get('explodedEntities_donut.json')
	.success(
		function(data) {
			$scope.stats = data;
			hideSpinner();
			new Morris.Donut({
				  // ID of the element in which to draw the chart.
				  element: 'eagleDonut',
				  // Chart data records -- each entry in this array corresponds to a point on
				  // the chart.
				  data: $scope.stats,
				});
		})
	.error(
		function() {
			show_notification("error", "Something really bad must have happened to our fellow hamster..");
			hideSpinner();
		});
});

