package eu.dnetlib.functionality.modular.ui.stats.controllers;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import lombok.extern.apachecommons.CommonsLog;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.google.gson.Gson;

import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.functionality.modular.ui.stats.model.GraphData;

/**
 * Web controller for the UI
 * 
 * @author Andrea Mannocci
 */
@CommonsLog
@Controller
public class StatsController {

	@Resource(name = "mdStoreServiceLocator")
	private ServiceLocator<MDStoreService> mdStoreLocator;

	@Resource(name = "lookupLocator")
	private ServiceLocator<ISLookUpService> lookupLocator;

	@RequestMapping(value = "/ui/ingestion_timeseries.json", method = RequestMethod.GET)
	public void getTimeSeries(final HttpServletResponse response) throws ISLookUpException, IOException {

		List<GraphData> timePlot = new ArrayList<GraphData>();
		for (int i = 0; i < 15; i++) {
			timePlot.add(new GraphData(String.valueOf(i), Math.random()));
		}

		IOUtils.copy(new StringReader(new Gson().toJson(timePlot)), response.getOutputStream());
	}

	@RequestMapping(value = "/ui/ingestion_donut.json", method = RequestMethod.GET)
	public void getDonut(final HttpServletResponse response) throws ISLookUpException, IOException {

		List<GraphData> donutPlot = new ArrayList<GraphData>();
		List<String> donutData = lookupLocator.getService().quickSearchProfile(
				"for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') "
						+ "for $y in collection('/db/DRIVER/MDStoreDSResources/MDStoreDSResourceType') "
						+ "where $x//*[WORKFLOW_NAME='collection']//PARAM[@name='mdId']=$y//RESOURCE_IDENTIFIER/@value "
						+ "return concat($x//PARAM[@name='providerName'], '§§§',$y//NUMBER_OF_RECORDS/text())");

		for (String s : donutData) {
			String[] tokens = s.split("§§§");
			donutPlot.add(new GraphData(tokens[0], Double.parseDouble(tokens[1])));
		}

		IOUtils.copy(new StringReader(new Gson().toJson(donutPlot)), response.getOutputStream());
	}

	@RequestMapping(value = "/ui/explodedEntities_donut.json", method = RequestMethod.GET)
	public void getGeneratedEntitiesDonut(final HttpServletResponse response) throws ISLookUpException, IOException {

		try {
			List<String> mdIdList = lookupLocator.getService().quickSearchProfile(
					"for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') "
							+ "return $x//*[WORKFLOW_NAME='index']//PARAM[@name='mdId']/text()");

			for (String mdId : mdIdList) {
				W3CEndpointReference deliveredMDRecords = mdStoreLocator.getService().deliverMDRecords(mdId, null, null, null);

			}

		} catch (MDStoreServiceException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		List<GraphData> donutPlot = new ArrayList<GraphData>();
		for (int i = 0; i < 5; i++) {
			donutPlot.add(new GraphData(String.valueOf(i), Math.random()));
		}

		IOUtils.copy(new StringReader(new Gson().toJson(donutPlot)), response.getOutputStream());
	}
}
