/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.miscutils.iterators.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Iterator;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xml.sax.SAXException;

public class XMLIterator
implements Iterator<String> {
    private ThreadLocal<XMLInputFactory> inputFactory = new ThreadLocal<XMLInputFactory>(){

        @Override
        protected XMLInputFactory initialValue() {
            return XMLInputFactory.newInstance();
        }
    };
    private ThreadLocal<XMLOutputFactory> outputFactory = new ThreadLocal<XMLOutputFactory>(){

        @Override
        protected XMLOutputFactory initialValue() {
            return XMLOutputFactory.newInstance();
        }
    };
    private ThreadLocal<XMLEventFactory> eventFactory = new ThreadLocal<XMLEventFactory>(){

        @Override
        protected XMLEventFactory initialValue() {
            return XMLEventFactory.newInstance();
        }
    };
    public static final String UTF_8 = "UTF-8";
    final XMLEventReader parser;
    private XMLEvent current = null;
    private String element;
    private InputStream inputStream;

    public XMLIterator(String element, InputStream inputStream) {
        this.element = element;
        this.inputStream = inputStream;
        this.parser = this.getParser();
        this.current = this.findElement(this.parser);
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public String next() {
        try {
            String result = this.copy(this.parser);
            this.current = this.findElement(this.parser);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private String copy(XMLEventReader parser) throws XMLStreamException, SAXException, IOException {
        StringWriter result = new StringWriter();
        XMLEventWriter writer = this.outputFactory.get().createXMLEventWriter(result);
        StartElement newRecord = this.eventFactory.get().createStartElement("", null, this.element, this.current.asStartElement().getAttributes(), null);
        writer.add(newRecord);
        while (parser.hasNext()) {
            XMLEvent event = parser.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals(this.element)) {
                writer.add(event);
                break;
            }
            writer.add(event);
        }
        writer.close();
        String string = result.toString();
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private XMLEvent findElement(XMLEventReader parser) {
        peek = this.peekEvent(parser);
        if (peek == null || !peek.isStartElement() || !this.element.equals(name = peek.asStartElement().getName().getLocalPart())) ** GOTO lbl7
        return peek;
lbl-1000:
        // 1 sources

        {
            event = this.nextEvent(parser);
            if (event == null || !event.isStartElement() || !this.element.equals(name = event.asStartElement().getName().getLocalPart())) continue;
            return event;
lbl7:
            // 2 sources

            ** while (parser.hasNext())
        }
lbl8:
        // 1 sources

        return null;
    }

    private XMLEvent nextEvent(XMLEventReader parser) {
        try {
            return parser.nextEvent();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private XMLEvent peekEvent(XMLEventReader parser) {
        try {
            return parser.peek();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private XMLEventReader getParser() {
        try {
            return this.inputFactory.get().createXMLEventReader(this.sanitize(this.inputStream));
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private Reader sanitize(InputStream in) {
        CharsetDecoder charsetDecoder = Charset.forName(UTF_8).newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        return new InputStreamReader(in, charsetDecoder);
    }
}

