/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.miscutils.functional.xml;

import eu.dnetlib.miscutils.functional.hash.Hashing;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DnetXsltFunctions {
    private static final Log log = LogFactory.getLog(DnetXsltFunctions.class);
    private static volatile long seedUniquifier = 8682522807148012L;
    private static String[] dateFormats = new String[]{"yyyy-MM-dd", "yyyy/MM/dd"};

    public static String extractYear(String s) throws ParseException {
        GregorianCalendar c = new GregorianCalendar();
        String[] stringArray = dateFormats;
        int n = dateFormats.length;
        int n2 = 0;
        while (n2 < n) {
            String format = stringArray[n2];
            try {
                c.setTime(new SimpleDateFormat(format).parse(s));
                String year = String.valueOf(c.get(1));
                return year;
            }
            catch (ParseException parseException) {
                ++n2;
            }
        }
        return "";
    }

    public static String randomInt(int max) {
        return String.valueOf(new Random(++seedUniquifier + System.nanoTime()).nextInt(max));
    }

    public static String md5(String s) {
        return Hashing.md5(s);
    }

    public static String decodeBase64(String s) {
        return Hashing.decodeBase64(s);
    }

    public static String encodeBase64(String s) {
        return Hashing.encodeBase64(s);
    }

    public static String lc(String s) {
        return s.toLowerCase();
    }

    public static String uc(String s) {
        return s.toUpperCase();
    }

    public static String decade(String s) {
        String res = DnetXsltFunctions._decade(s.trim());
        log.debug((Object)(String.valueOf(s) + "--> " + res));
        return res;
    }

    private static String _decade(String s) {
        Matcher m1 = Pattern.compile("(\\d\\d\\d)\\d").matcher(s);
        if (m1.find()) {
            String part = m1.group(1);
            return String.valueOf(part) + "0-" + part + "9";
        }
        Matcher m2 = Pattern.compile("(\\d)\\d").matcher(s);
        if (m2.find()) {
            String part = m2.group(1);
            return "19" + part + "0-19" + part + "9";
        }
        return "n/a";
    }
}

