/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.miscutils.functional.xml;

import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;

public abstract class AbstractApplyXslt<K>
implements UnaryFunction<String, K> {
    private static final String UNKNOWN_XSLT_NAME = "unknown xslt name";
    private static final Log log = LogFactory.getLog(AbstractApplyXslt.class);
    private Transformer transformer;
    private String xsltName;

    public AbstractApplyXslt(Resource xslt) {
        this(xslt, null);
    }

    public AbstractApplyXslt(Resource xslt, Map<String, String> parameters) {
        this(new StreamSource(AbstractApplyXslt.getInputStream(xslt)), AbstractApplyXslt.getFileName(xslt), parameters);
    }

    public AbstractApplyXslt(String xslt) {
        this(xslt, UNKNOWN_XSLT_NAME);
    }

    public AbstractApplyXslt(String xslt, String name) {
        this(xslt, name, null);
    }

    public AbstractApplyXslt(String xslt, String name, Map<String, String> parameters) {
        this(new StreamSource(new StringReader(xslt)), name, parameters);
    }

    public AbstractApplyXslt(Source xslt) {
        this(xslt, UNKNOWN_XSLT_NAME);
    }

    public AbstractApplyXslt(Source xslt, String name) {
        this(xslt, name, null);
    }

    public AbstractApplyXslt(Source xslt, String name, Map<String, String> parameters) {
        try {
            this.xsltName = name;
            this.transformer = TransformerFactory.newInstance().newTransformer(xslt);
            if (parameters != null) {
                for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                    this.transformer.setParameter(parameter.getKey(), parameter.getValue());
                }
            }
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String evaluate(K input) {
        try {
            StringWriter output = new StringWriter();
            this.transformer.transform(this.toStream(input), new StreamResult(output));
            return output.toString();
        }
        catch (TransformerException e) {
            log.debug((Object)"cannot transform record", (Throwable)e);
            return "";
        }
    }

    public abstract Source toStream(K var1);

    private static InputStream getInputStream(Resource xslt) {
        try {
            return xslt.getInputStream();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String getFileName(Resource xslt) {
        try {
            return xslt.getURL().getPath();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public String getXsltName() {
        return this.xsltName;
    }

    public void setXsltName(String xsltName) {
        this.xsltName = xsltName;
    }
}

