/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.miscutils.collections;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.BitSet;
import java.util.Collection;

public class BloomFilter<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BitSet bitset;
    private int bitSetSize;
    private double bitsPerElement;
    private int expectedNumberOfFilterElements;
    private int numberOfAddedElements;
    private int k;
    static final Charset charset;
    static final String hashName = "MD5";
    static final MessageDigest digestFunction;

    static {
        MessageDigest tmp;
        charset = Charset.forName("UTF-8");
        try {
            tmp = MessageDigest.getInstance(hashName);
        }
        catch (NoSuchAlgorithmException e) {
            tmp = null;
        }
        digestFunction = tmp;
    }

    public BloomFilter(double c, int n, int k) {
        this.expectedNumberOfFilterElements = n;
        this.k = k;
        this.bitsPerElement = c;
        this.bitSetSize = (int)Math.ceil(c * (double)n);
        this.numberOfAddedElements = 0;
        this.bitset = new BitSet(this.bitSetSize);
    }

    public BloomFilter(int bitSetSize, int expectedNumberOElements) {
        this((double)bitSetSize / (double)expectedNumberOElements, expectedNumberOElements, (int)Math.round((double)bitSetSize / (double)expectedNumberOElements * Math.log(2.0)));
    }

    public BloomFilter(double falsePositiveProbability, int expectedNumberOfElements) {
        this(Math.ceil(-(Math.log(falsePositiveProbability) / Math.log(2.0))) / Math.log(2.0), expectedNumberOfElements, (int)Math.ceil(-(Math.log(falsePositiveProbability) / Math.log(2.0))));
    }

    public BloomFilter(int bitSetSize, int expectedNumberOfFilterElements, int actualNumberOfFilterElements, BitSet filterData) {
        this(bitSetSize, expectedNumberOfFilterElements);
        this.bitset = filterData;
        this.numberOfAddedElements = actualNumberOfFilterElements;
    }

    public static int createHash(String val, Charset charset) {
        return BloomFilter.createHash(val.getBytes(charset));
    }

    public static int createHash(String val) {
        return BloomFilter.createHash(val, charset);
    }

    public static int createHash(byte[] data) {
        return BloomFilter.createHashes(data, 1)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] createHashes(byte[] data, int hashes) {
        int[] result = new int[hashes];
        int k = 0;
        byte salt = 0;
        while (k < hashes) {
            byte[] digest;
            MessageDigest messageDigest = digestFunction;
            synchronized (messageDigest) {
                digestFunction.update(salt);
                salt = (byte)(salt + 1);
                digest = digestFunction.digest(data);
            }
            int i = 0;
            while (i < digest.length / 4 && k < hashes) {
                int h = 0;
                int j = i * 4;
                while (j < i * 4 + 4) {
                    h <<= 8;
                    h |= digest[j] & 0xFF;
                    ++j;
                }
                result[k] = h;
                ++k;
                ++i;
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BloomFilter other = (BloomFilter)obj;
        if (this.expectedNumberOfFilterElements != other.expectedNumberOfFilterElements) {
            return false;
        }
        if (this.k != other.k) {
            return false;
        }
        if (this.bitSetSize != other.bitSetSize) {
            return false;
        }
        return this.bitset == other.bitset || this.bitset != null && this.bitset.equals(other.bitset);
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (this.bitset != null ? this.bitset.hashCode() : 0);
        hash = 61 * hash + this.expectedNumberOfFilterElements;
        hash = 61 * hash + this.bitSetSize;
        hash = 61 * hash + this.k;
        return hash;
    }

    public double expectedFalsePositiveProbability() {
        return this.getFalsePositiveProbability(this.expectedNumberOfFilterElements);
    }

    public double getFalsePositiveProbability(double numberOfElements) {
        return Math.pow(1.0 - Math.exp((double)(-this.k) * numberOfElements / (double)this.bitSetSize), this.k);
    }

    public double getFalsePositiveProbability() {
        return this.getFalsePositiveProbability(this.numberOfAddedElements);
    }

    public int getK() {
        return this.k;
    }

    public void clear() {
        this.bitset.clear();
        this.numberOfAddedElements = 0;
    }

    public void add(E element) {
        this.add(element.toString().getBytes(charset));
    }

    public void add(byte[] bytes) {
        int[] hashes;
        int[] nArray = hashes = BloomFilter.createHashes(bytes, this.k);
        int n = hashes.length;
        int n2 = 0;
        while (n2 < n) {
            int hash = nArray[n2];
            this.bitset.set(Math.abs(hash % this.bitSetSize), true);
            ++n2;
        }
        ++this.numberOfAddedElements;
    }

    public void addAll(Collection<? extends E> c) {
        for (E element : c) {
            this.add(element);
        }
    }

    public boolean contains(E element) {
        return this.contains(element.toString().getBytes(charset));
    }

    public boolean contains(byte[] bytes) {
        int[] hashes;
        int[] nArray = hashes = BloomFilter.createHashes(bytes, this.k);
        int n = hashes.length;
        int n2 = 0;
        while (n2 < n) {
            int hash = nArray[n2];
            if (!this.bitset.get(Math.abs(hash % this.bitSetSize))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean containsAll(Collection<? extends E> c) {
        for (E element : c) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    public boolean getBit(int bit) {
        return this.bitset.get(bit);
    }

    public void setBit(int bit, boolean value) {
        this.bitset.set(bit, value);
    }

    public BitSet getBitSet() {
        return this.bitset;
    }

    public int size() {
        return this.bitSetSize;
    }

    public int count() {
        return this.numberOfAddedElements;
    }

    public int getExpectedNumberOfElements() {
        return this.expectedNumberOfFilterElements;
    }

    public double getExpectedBitsPerElement() {
        return this.bitsPerElement;
    }

    public double getBitsPerElement() {
        return (double)this.bitSetSize / (double)this.numberOfAddedElements;
    }
}

