/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty;

import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.transport.HttpUriMapper;
import org.apache.cxf.transport.http_jetty.JettyConnectorFactory;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.http_jetty.ServerEngine;
import org.apache.cxf.transport.http_jetty.ThreadingParameters;
import org.apache.cxf.transport.https_jetty.JettySslConnectorFactory;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.thread.OldQueuedThreadPool;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyHTTPServerEngine
implements ServerEngine {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogUtils.getL7dLogger(JettyHTTPServerEngine.class);
    protected Bus bus;
    protected JettyHTTPServerEngineFactory factory;
    private int port;
    private String host;
    private String protocol = "http";
    private Boolean isSessionSupport = false;
    private Boolean isReuseAddress = true;
    private Boolean continuationsEnabled = true;
    private int servantCount;
    private Server server;
    private Connector connector;
    private List<Handler> handlers;
    private JettyConnectorFactory connectorFactory;
    private ContextHandlerCollection contexts;
    private SessionManager sessionManager;
    private TLSServerParameters tlsServerParameters;
    private ThreadingParameters threadingParameters;
    private boolean configFinalized;

    public JettyHTTPServerEngine(JettyHTTPServerEngineFactory fac, Bus bus, String host, int port) {
        this.bus = bus;
        this.factory = fac;
        this.host = host;
        this.port = port;
    }

    public JettyHTTPServerEngine() {
    }

    public void setJettyHTTPServerEngineFactory(JettyHTTPServerEngineFactory fac) {
        this.factory = fac;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setContinuationsEnabled(boolean enabled) {
        this.continuationsEnabled = enabled;
    }

    public boolean getContinuationsEnabled() {
        return this.continuationsEnabled;
    }

    @Resource(name="cxf")
    public void setBus(Bus b) {
        this.bus = b;
    }

    public Bus getBus() {
        return this.bus;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void shutdown() {
        if (this.shouldDestroyPort()) {
            if (this.factory != null && this.servantCount == 0) {
                this.factory.destroyForPort(this.port);
            } else {
                LOG.log(Level.WARNING, "FAILED_TO_SHUTDOWN_ENGINE_MSG", this.port);
            }
        }
    }

    private boolean shouldDestroyPort() {
        String s = System.getProperty("org.apache.cxf.transports.http_jetty.DontClosePort");
        return Boolean.valueOf(s) == false;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server s) {
        this.server = s;
    }

    public void setConnector(Connector c) {
        this.connector = c;
    }

    public void setHandlers(List<Handler> h) {
        this.handlers = h;
    }

    public void setSessionSupport(boolean support) {
        this.isSessionSupport = support;
    }

    public boolean isSessionSupport() {
        return this.isSessionSupport;
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public boolean isReuseAddress() {
        return this.isReuseAddress;
    }

    public void setReuseAddress(boolean reuse) {
        this.isReuseAddress = reuse;
    }

    @Override
    public synchronized void addServant(URL url, JettyHTTPHandler handler) {
        if (this.server == null) {
            DefaultHandler defaultHandler = null;
            this.server = new Server();
            Container.Listener mBeanContainer = this.factory.getMBeanContainer();
            if (mBeanContainer != null) {
                this.server.getContainer().addEventListener(mBeanContainer);
            }
            if (this.connector == null) {
                this.connector = this.connectorFactory.createConnector(this.getHost(), this.getPort());
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("connector.host: " + this.connector.getHost() == null ? "null" : "\"" + this.connector.getHost() + "\"");
                    LOG.finer("connector.port: " + this.connector.getPort());
                }
            }
            this.server.addConnector(this.connector);
            int numberOfHandlers = 1;
            if (this.handlers != null) {
                numberOfHandlers += this.handlers.size();
            }
            Handler existingHandler = this.server.getHandler();
            HandlerCollection handlerCollection = null;
            boolean existingHandlerCollection = existingHandler instanceof HandlerCollection;
            if (existingHandlerCollection) {
                handlerCollection = (HandlerCollection)existingHandler;
            }
            if (!(existingHandlerCollection || existingHandler == null && numberOfHandlers <= 1)) {
                handlerCollection = new HandlerCollection();
                if (existingHandler != null) {
                    handlerCollection.addHandler(existingHandler);
                }
                this.server.setHandler((Handler)handlerCollection);
            }
            if (this.handlers != null && this.handlers.size() > 0) {
                for (Handler h : this.handlers) {
                    if (h instanceof DefaultHandler) {
                        defaultHandler = (DefaultHandler)h;
                        continue;
                    }
                    handlerCollection.addHandler(h);
                }
            }
            this.contexts = new ContextHandlerCollection();
            if (handlerCollection != null) {
                handlerCollection.addHandler((Handler)this.contexts);
                if (defaultHandler != null) {
                    handlerCollection.addHandler(defaultHandler);
                }
            } else {
                this.server.setHandler((Handler)this.contexts);
            }
            try {
                this.setReuseAddress(this.connector);
                this.setupThreadPool();
                this.server.start();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "START_UP_SERVER_FAILED_MSG", new Object[]{e.getMessage(), this.port});
                try {
                    this.server.stop();
                    this.server.destroy();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.server = null;
                throw new Fault(new Message("START_UP_SERVER_FAILED_MSG", LOG, new Object[]{e.getMessage(), this.port}), (Throwable)e);
            }
        }
        String contextName = HttpUriMapper.getContextName((String)url.getPath());
        ContextHandler context = new ContextHandler();
        context.setContextPath(contextName);
        if (this.isSessionSupport.booleanValue()) {
            if (this.sessionManager == null) {
                this.sessionManager = new HashSessionManager();
                HashSessionIdManager idManager = new HashSessionIdManager();
                this.sessionManager.setIdManager((SessionIdManager)idManager);
            }
            SessionHandler sessionHandler = new SessionHandler(this.sessionManager);
            sessionHandler.setHandler((Handler)handler);
            context.setHandler((Handler)sessionHandler);
        } else {
            context.setHandler((Handler)handler);
        }
        this.contexts.addHandler((Handler)context);
        ContextHandler.Context sc = context.getServletContext();
        handler.setServletContext((ServletContext)sc);
        String smap = HttpUriMapper.getResourceBase((String)url.getPath());
        handler.setName(smap);
        if (this.contexts.isStarted()) {
            try {
                context.start();
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "ADD_HANDLER_FAILED_MSG", new Object[]{ex.getMessage()});
            }
        }
        ++this.servantCount;
    }

    protected void setupThreadPool() {
        AbstractConnector aconn = (AbstractConnector)this.connector;
        if (this.isSetThreadingParameters()) {
            ThreadPool pool = aconn.getThreadPool();
            if (pool == null) {
                pool = new QueuedThreadPool();
                aconn.setThreadPool(pool);
            }
            if (pool instanceof OldQueuedThreadPool) {
                OldQueuedThreadPool pl = (OldQueuedThreadPool)pool;
                if (this.getThreadingParameters().isSetMinThreads()) {
                    pl.setMinThreads(this.getThreadingParameters().getMinThreads());
                }
                if (this.getThreadingParameters().isSetMaxThreads()) {
                    pl.setMaxThreads(this.getThreadingParameters().getMaxThreads());
                }
            } else if (pool instanceof QueuedThreadPool) {
                QueuedThreadPool pl = (QueuedThreadPool)pool;
                if (this.getThreadingParameters().isSetMinThreads()) {
                    pl.setMinThreads(this.getThreadingParameters().getMinThreads());
                }
                if (this.getThreadingParameters().isSetMaxThreads()) {
                    pl.setMaxThreads(this.getThreadingParameters().getMaxThreads());
                }
            }
        }
    }

    private void setReuseAddress(Connector conn) throws IOException {
        if (conn instanceof AbstractConnector) {
            ((AbstractConnector)conn).setReuseAddress(this.isReuseAddress());
        } else {
            LOG.log(Level.INFO, "UNKNOWN_CONNECTOR_MSG", new Object[]{conn});
        }
    }

    @Override
    public synchronized void removeServant(URL url) {
        String contextName = HttpUriMapper.getContextName((String)url.getPath());
        String smap = HttpUriMapper.getResourceBase((String)url.getPath());
        boolean found = false;
        if (this.server != null && this.server.isRunning()) {
            for (Handler handler : this.contexts.getChildHandlersByClass(ContextHandler.class)) {
                Handler jh;
                ContextHandler contextHandler = null;
                if (!(handler instanceof ContextHandler) || !((jh = (contextHandler = (ContextHandler)handler).getHandler()) instanceof JettyHTTPHandler) || !contextName.equals(contextHandler.getContextPath()) || !((JettyHTTPHandler)jh).getName().equals(smap)) continue;
                try {
                    this.contexts.removeHandler(handler);
                    handler.stop();
                    handler.destroy();
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "REMOVE_HANDLER_FAILED_MSG", new Object[]{ex.getMessage()});
                }
                found = true;
                break;
            }
        }
        if (!found) {
            LOG.log(Level.WARNING, "CAN_NOT_FIND_HANDLER_MSG", new Object[]{url});
        }
        --this.servantCount;
    }

    @Override
    public synchronized Handler getServant(URL url) {
        String contextName = HttpUriMapper.getContextName((String)url.getPath());
        Handler ret = null;
        if (this.server != null) {
            for (Handler handler : this.server.getChildHandlersByClass(ContextHandler.class)) {
                ContextHandler contextHandler = null;
                if (!(handler instanceof ContextHandler) || !contextName.equals((contextHandler = (ContextHandler)handler).getContextPath())) continue;
                ret = contextHandler.getHandler();
                break;
            }
        }
        return ret;
    }

    public synchronized ContextHandler getContextHandler(URL url) {
        String contextName = HttpUriMapper.getContextName((String)url.getPath());
        ContextHandler ret = null;
        if (this.server != null) {
            for (Handler handler : this.server.getChildHandlersByClass(ContextHandler.class)) {
                ContextHandler contextHandler = null;
                if (!(handler instanceof ContextHandler) || !contextName.equals((contextHandler = (ContextHandler)handler).getContextPath())) continue;
                ret = contextHandler;
                break;
            }
        }
        return ret;
    }

    protected void retrieveListenerFactory() {
        if (this.tlsServerParameters != null) {
            if (null != this.connector && !(this.connector instanceof SslSocketConnector)) {
                LOG.warning("Connector " + this.connector + " for JettyServerEngine Port " + this.port + " does not support SSL connections.");
                return;
            }
            this.connectorFactory = this.getHTTPSConnectorFactory(this.tlsServerParameters);
            this.protocol = "https";
        } else {
            if (this.connector instanceof SslSocketConnector) {
                throw new RuntimeException("Connector " + this.connector + " for JettyServerEngine Port " + this.port + " does not support non-SSL connections.");
            }
            this.connectorFactory = this.getHTTPConnectorFactory();
            this.protocol = "http";
        }
        LOG.fine("Configured port " + this.port + " for \"" + this.protocol + "\".");
    }

    protected JettyConnectorFactory getHTTPConnectorFactory() {
        return new JettyConnectorFactory(){

            public AbstractConnector createConnector(int porto) {
                return this.createConnector(null, porto);
            }

            public AbstractConnector createConnector(String hosto, int porto) {
                SelectChannelConnector result = new SelectChannelConnector();
                assert (porto == JettyHTTPServerEngine.this.port);
                assert (hosto == JettyHTTPServerEngine.this.host);
                if (hosto != null) {
                    result.setHost(hosto);
                }
                result.setPort(porto);
                return result;
            }
        };
    }

    protected JettyConnectorFactory getHTTPSConnectorFactory(TLSServerParameters tlsParams) {
        return new JettySslConnectorFactory(tlsParams);
    }

    @PostConstruct
    public void finalizeConfig() throws GeneralSecurityException, IOException {
        this.retrieveEngineFactory();
        this.retrieveListenerFactory();
        this.checkConnectorPort();
        this.configFinalized = true;
    }

    protected void retrieveEngineFactory() {
        if (null != this.bus && null == this.factory) {
            this.factory = (JettyHTTPServerEngineFactory)this.bus.getExtension(JettyHTTPServerEngineFactory.class);
        }
    }

    private void checkConnectorPort() throws IOException {
        if (null != this.connector && this.port != this.connector.getPort()) {
            throw new IOException("Error: Connector port " + this.connector.getPort() + " does not match" + " with the server engine port " + this.port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() throws Exception {
        if (this.server != null) {
            try {
                this.connector.stop();
                this.connector.close();
            }
            finally {
                this.server.stop();
                this.server.destroy();
                this.server = null;
            }
        }
    }

    public void setTlsServerParameters(TLSServerParameters params) throws IOException {
        this.tlsServerParameters = params;
        if (this.configFinalized) {
            this.retrieveListenerFactory();
        }
    }

    public TLSServerParameters getTlsServerParameters() {
        return this.tlsServerParameters;
    }

    public void setThreadingParameters(ThreadingParameters params) {
        this.threadingParameters = params;
    }

    public boolean isSetThreadingParameters() {
        return this.threadingParameters != null;
    }

    public ThreadingParameters getThreadingParameters() {
        return this.threadingParameters;
    }
}

