/*
 * Decompiled with CFR 0.152.
 */
package gate.util.compilers.eclipse.jdt.internal.compiler.apt.dispatch;

import gate.util.compilers.eclipse.jdt.internal.compiler.CompilationResult;
import gate.util.compilers.eclipse.jdt.internal.compiler.apt.dispatch.AptProblem;
import gate.util.compilers.eclipse.jdt.internal.compiler.apt.model.AnnotationMemberValue;
import gate.util.compilers.eclipse.jdt.internal.compiler.apt.model.AnnotationMirrorImpl;
import gate.util.compilers.eclipse.jdt.internal.compiler.apt.model.ExecutableElementImpl;
import gate.util.compilers.eclipse.jdt.internal.compiler.apt.model.TypeElementImpl;
import gate.util.compilers.eclipse.jdt.internal.compiler.apt.model.VariableElementImpl;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.Annotation;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import gate.util.compilers.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.AptSourceLocalVariableBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.Binding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.util.Util;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public class BaseMessagerImpl {
    static final String[] NO_ARGUMENTS = new String[0];

    public static AptProblem createProblem(Diagnostic.Kind kind, CharSequence msg, Element e, AnnotationMirror a, AnnotationValue v) {
        int severity;
        ReferenceContext referenceContext = null;
        Annotation[] elementAnnotations = null;
        int startPosition = 0;
        int endPosition = 0;
        if (e != null) {
            switch (e.getKind()) {
                case ENUM: 
                case CLASS: 
                case ANNOTATION_TYPE: 
                case INTERFACE: {
                    TypeElementImpl typeElementImpl = (TypeElementImpl)e;
                    Binding typeBinding = typeElementImpl._binding;
                    if (!(typeBinding instanceof SourceTypeBinding)) break;
                    SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)typeBinding;
                    TypeDeclaration typeDeclaration = (TypeDeclaration)sourceTypeBinding.scope.referenceContext();
                    referenceContext = typeDeclaration;
                    elementAnnotations = typeDeclaration.annotations;
                    startPosition = typeDeclaration.sourceStart;
                    endPosition = typeDeclaration.sourceEnd;
                    break;
                }
                case PACKAGE: {
                    break;
                }
                case METHOD: 
                case CONSTRUCTOR: {
                    MethodBinding methodBinding;
                    AbstractMethodDeclaration sourceMethod;
                    ExecutableElementImpl executableElementImpl = (ExecutableElementImpl)e;
                    Binding binding = executableElementImpl._binding;
                    if (!(binding instanceof MethodBinding) || (sourceMethod = (methodBinding = (MethodBinding)binding).sourceMethod()) == null) break;
                    referenceContext = sourceMethod;
                    elementAnnotations = sourceMethod.annotations;
                    startPosition = sourceMethod.sourceStart;
                    endPosition = sourceMethod.sourceEnd;
                    break;
                }
                case ENUM_CONSTANT: {
                    break;
                }
                case EXCEPTION_PARAMETER: {
                    break;
                }
                case FIELD: 
                case PARAMETER: {
                    VariableElementImpl variableElementImpl = (VariableElementImpl)e;
                    Binding binding = variableElementImpl._binding;
                    if (binding instanceof FieldBinding) {
                        FieldBinding fieldBinding = (FieldBinding)binding;
                        FieldDeclaration fieldDeclaration = fieldBinding.sourceField();
                        if (fieldDeclaration == null) break;
                        ReferenceBinding declaringClass = fieldBinding.declaringClass;
                        if (declaringClass instanceof SourceTypeBinding) {
                            SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)declaringClass;
                            TypeDeclaration typeDeclaration = (TypeDeclaration)sourceTypeBinding.scope.referenceContext();
                            referenceContext = typeDeclaration;
                        }
                        elementAnnotations = fieldDeclaration.annotations;
                        startPosition = fieldDeclaration.sourceStart;
                        endPosition = fieldDeclaration.sourceEnd;
                        break;
                    }
                    if (!(binding instanceof AptSourceLocalVariableBinding)) break;
                    AptSourceLocalVariableBinding parameterBinding = (AptSourceLocalVariableBinding)binding;
                    LocalDeclaration parameterDeclaration = parameterBinding.declaration;
                    if (parameterDeclaration == null) break;
                    MethodBinding methodBinding = parameterBinding.methodBinding;
                    if (methodBinding != null) {
                        referenceContext = methodBinding.sourceMethod();
                    }
                    elementAnnotations = parameterDeclaration.annotations;
                    startPosition = parameterDeclaration.sourceStart;
                    endPosition = parameterDeclaration.sourceEnd;
                    break;
                }
                case STATIC_INIT: 
                case INSTANCE_INIT: {
                    break;
                }
            }
        }
        StringBuilder builder = new StringBuilder();
        if (msg != null) {
            builder.append(msg);
        }
        if (a != null && elementAnnotations != null) {
            AnnotationBinding annotationBinding = ((AnnotationMirrorImpl)a)._binding;
            Annotation annotation = null;
            int i = 0;
            while (annotation == null && i < elementAnnotations.length) {
                if (annotationBinding == elementAnnotations[i].getCompilerAnnotation()) {
                    annotation = elementAnnotations[i];
                }
                ++i;
            }
            if (annotation != null) {
                startPosition = annotation.sourceStart;
                endPosition = annotation.sourceEnd;
                if (v != null && v instanceof AnnotationMemberValue) {
                    MethodBinding methodBinding = ((AnnotationMemberValue)v).getMethodBinding();
                    MemberValuePair[] memberValuePairs = annotation.memberValuePairs();
                    MemberValuePair memberValuePair = null;
                    int i2 = 0;
                    while (memberValuePair == null && i2 < memberValuePairs.length) {
                        if (methodBinding == memberValuePairs[i2].binding) {
                            memberValuePair = memberValuePairs[i2];
                        }
                        ++i2;
                    }
                    if (memberValuePair != null) {
                        startPosition = memberValuePair.sourceStart;
                        endPosition = memberValuePair.sourceEnd;
                    }
                }
            }
        }
        int lineNumber = 0;
        int columnNumber = 1;
        char[] fileName = null;
        if (referenceContext != null) {
            int n;
            CompilationResult result = referenceContext.compilationResult();
            fileName = result.fileName;
            int[] lineEnds = null;
            if (startPosition >= 0) {
                lineEnds = result.getLineSeparatorPositions();
                n = Util.getLineNumber(startPosition, lineEnds, 0, lineEnds.length - 1);
            } else {
                n = 0;
            }
            lineNumber = n;
            columnNumber = startPosition >= 0 ? Util.searchColumnNumber(result.getLineSeparatorPositions(), lineNumber, startPosition) : 0;
        }
        switch (kind) {
            case ERROR: {
                severity = 1;
                break;
            }
            default: {
                severity = 0;
            }
        }
        return new AptProblem(referenceContext, fileName, String.valueOf(builder), 0, NO_ARGUMENTS, severity, startPosition, endPosition, lineNumber, columnNumber);
    }
}

