/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.OutputStream;
import java.util.Date;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.tool.Utils;

public class SegmentGraph
implements Runnable {
    private final File path;
    private final OutputStream out;
    private final Date epoch;
    private final String filter;

    public static Builder builder() {
        return new Builder();
    }

    private SegmentGraph(Builder builder) {
        this.path = builder.path;
        this.out = builder.out;
        this.epoch = builder.epoch;
        this.filter = builder.filter;
    }

    @Override
    public void run() {
        try (FileStore.ReadOnlyStore store = Utils.openReadOnlyFileStore(this.path);){
            org.apache.jackrabbit.oak.segment.SegmentGraph.writeSegmentGraph(store, this.out, this.epoch, this.filter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Builder {
        private File path;
        private Date epoch;
        private String filter;
        private OutputStream out;

        private Builder() {
        }

        public Builder withPath(File path) {
            this.path = (File)Preconditions.checkNotNull((Object)path);
            return this;
        }

        public Builder withEpoch(Date epoch) {
            this.epoch = (Date)Preconditions.checkNotNull((Object)epoch);
            return this;
        }

        public Builder withFilter(String filter) {
            this.filter = (String)Preconditions.checkNotNull((Object)filter);
            return this;
        }

        public Builder withOutput(OutputStream out) {
            this.out = (OutputStream)Preconditions.checkNotNull((Object)out);
            return this;
        }

        public Runnable build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.out);
            return new SegmentGraph(this);
        }
    }
}

