/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.store;

import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.jackrabbit.oak.segment.standby.jmx.ObservablePartnerMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunicationObserver {
    private static final int MAX_CLIENT_STATISTICS = 10;
    private static final Logger log = LoggerFactory.getLogger(CommunicationObserver.class);
    private final String identifier;
    private final Map<String, CommunicationPartnerMBean> partnerDetails;

    public CommunicationObserver(String myID) {
        this.identifier = myID;
        this.partnerDetails = new HashMap<String, CommunicationPartnerMBean>();
    }

    private void unregister(CommunicationPartnerMBean m) {
        MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
        try {
            jmxServer.unregisterMBean(m.getMBeanName());
        }
        catch (Exception e) {
            log.error("error unregistering mbean for client '" + m.getName() + "'", (Throwable)e);
        }
    }

    public void unregister() {
        for (CommunicationPartnerMBean m : this.partnerDetails.values()) {
            this.unregister(m);
        }
    }

    public void gotMessageFrom(String client, String request, InetSocketAddress remote) throws MalformedObjectNameException {
        log.debug("got message '" + request + "' from client " + client);
        CommunicationPartnerMBean m = this.partnerDetails.get(client);
        boolean register = false;
        if (m == null) {
            this.cleanUp();
            m = new CommunicationPartnerMBean(client);
            m.remoteAddress = remote.getAddress().getHostAddress();
            m.remotePort = remote.getPort();
            register = true;
        }
        m.lastSeen = new Date();
        m.lastRequest = request;
        this.partnerDetails.put(client, m);
        if (register) {
            MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
            try {
                jmxServer.registerMBean(new StandardMBean(m, ObservablePartnerMBean.class), m.getMBeanName());
            }
            catch (Exception e) {
                log.error("can register mbean for client '" + m.getName() + "'", (Throwable)e);
            }
        }
    }

    public void didSendSegmentBytes(String client, int size) {
        log.debug("did send segment with " + size + " bytes to client " + client);
        CommunicationPartnerMBean m = this.partnerDetails.get(client);
        ++m.segmentsSent;
        m.segmentBytesSent += (long)size;
        this.partnerDetails.put(client, m);
    }

    public void didSendBinariesBytes(String client, int size) {
        log.debug("did send binary with " + size + " bytes to client " + client);
        CommunicationPartnerMBean m = this.partnerDetails.get(client);
        ++m.binariesSent;
        m.binariesBytesSent += (long)size;
        this.partnerDetails.put(client, m);
    }

    public String getID() {
        return this.identifier;
    }

    private void cleanUp() {
        while (this.partnerDetails.size() >= 10) {
            CommunicationPartnerMBean oldestEntry = this.oldestEntry();
            if (oldestEntry == null) {
                return;
            }
            log.info("housekeeping: removing statistics for " + oldestEntry.getName());
            this.unregister(oldestEntry);
            this.partnerDetails.remove(oldestEntry.getName());
        }
    }

    private CommunicationPartnerMBean oldestEntry() {
        CommunicationPartnerMBean ret = null;
        for (CommunicationPartnerMBean m : this.partnerDetails.values()) {
            if (ret != null && !ret.lastSeen.after(m.lastSeen)) continue;
            ret = m;
        }
        return ret;
    }

    private class CommunicationPartnerMBean
    implements ObservablePartnerMBean {
        private final ObjectName mbeanName;
        private final String clientName;
        public String lastRequest;
        public Date lastSeen;
        public String remoteAddress;
        public int remotePort;
        public long segmentsSent;
        public long segmentBytesSent;
        public long binariesSent;
        public long binariesBytesSent;

        public CommunicationPartnerMBean(String clientName) throws MalformedObjectNameException {
            this.clientName = clientName;
            this.mbeanName = new ObjectName("org.apache.jackrabbit.oak:name=Status,type=\"Standby\",id=\"Client " + clientName + "\"");
        }

        public ObjectName getMBeanName() {
            return this.mbeanName;
        }

        @Override
        public String getName() {
            return this.clientName;
        }

        @Override
        public String getRemoteAddress() {
            return this.remoteAddress;
        }

        @Override
        public String getLastRequest() {
            return this.lastRequest;
        }

        @Override
        public int getRemotePort() {
            return this.remotePort;
        }

        @Override
        public String getLastSeenTimestamp() {
            return this.lastSeen == null ? null : this.lastSeen.toString();
        }

        @Override
        public long getTransferredSegments() {
            return this.segmentsSent;
        }

        @Override
        public long getTransferredSegmentBytes() {
            return this.segmentBytesSent;
        }

        @Override
        public long getTransferredBinaries() {
            return this.binariesSent;
        }

        @Override
        public long getTransferredBinariesBytes() {
            return this.binariesBytesSent;
        }
    }
}

