/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetSocketAddress;
import org.apache.jackrabbit.oak.segment.standby.codec.GetBlobRequest;
import org.apache.jackrabbit.oak.segment.standby.codec.GetHeadRequest;
import org.apache.jackrabbit.oak.segment.standby.codec.GetSegmentRequest;
import org.apache.jackrabbit.oak.segment.standby.store.CommunicationObserver;

class RequestObserverHandler
extends ChannelInboundHandlerAdapter {
    private final CommunicationObserver observer;

    RequestObserverHandler(CommunicationObserver observer) {
        this.observer = observer;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        InetSocketAddress address = (InetSocketAddress)ctx.channel().remoteAddress();
        if (msg instanceof GetHeadRequest) {
            this.onGetHeadRequest((GetHeadRequest)msg, address);
        } else if (msg instanceof GetSegmentRequest) {
            this.onGetSegmentRequest((GetSegmentRequest)msg, address);
        } else if (msg instanceof GetBlobRequest) {
            this.onGetBlobRequest((GetBlobRequest)msg, address);
        }
        ctx.fireChannelRead(msg);
    }

    private void onGetHeadRequest(GetHeadRequest request, InetSocketAddress address) throws Exception {
        this.observer.gotMessageFrom(request.getClientId(), "get head", address);
    }

    private void onGetSegmentRequest(GetSegmentRequest request, InetSocketAddress address) throws Exception {
        this.observer.gotMessageFrom(request.getClientId(), "get segment", address);
    }

    private void onGetBlobRequest(GetBlobRequest request, InetSocketAddress address) throws Exception {
        this.observer.gotMessageFrom(request.getClientId(), "get blob id", address);
    }
}

