/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreBlob;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.standby.server.StandbyBlobReader;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultStandbyBlobReader
implements StandbyBlobReader {
    private final Logger log = LoggerFactory.getLogger(DefaultStandbyBlobReader.class);
    private final FileStore store;

    DefaultStandbyBlobReader(FileStore store) {
        this.store = store;
    }

    @Override
    public byte[] readBlob(String blobId) {
        BlobStore blobStore = this.store.getBlobStore();
        if (blobStore == null) {
            return null;
        }
        byte[] bytes = null;
        try (InputStream s = new BlobStoreBlob(blobStore, blobId).getNewStream();){
            bytes = IOUtils.toByteArray((InputStream)s);
        }
        catch (IOException e) {
            this.log.warn("Error while reading blob content", (Throwable)e);
        }
        return bytes;
    }
}

