/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.codec;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.nio.charset.Charset;
import org.apache.jackrabbit.oak.segment.standby.codec.GetBlobResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetBlobResponseEncoder
extends MessageToByteEncoder<GetBlobResponse> {
    private static final Logger log = LoggerFactory.getLogger(GetBlobResponseEncoder.class);

    protected void encode(ChannelHandlerContext ctx, GetBlobResponse msg, ByteBuf out) throws Exception {
        log.debug("Sending blob {} to client {}", (Object)msg.getBlobId(), (Object)msg.getClientId());
        this.encode(msg.getBlobId(), msg.getBlobData(), out);
    }

    private void encode(String blobId, byte[] data, ByteBuf out) throws Exception {
        byte[] blobIdBytes = blobId.getBytes(Charset.forName("UTF-8"));
        Hasher hasher = Hashing.murmur3_32().newHasher();
        long hash = hasher.putBytes(data).hash().padToLong();
        out.writeInt(5 + blobIdBytes.length + 8 + data.length);
        out.writeByte(2);
        out.writeInt(blobIdBytes.length);
        out.writeBytes(blobIdBytes);
        out.writeLong(hash);
        out.writeBytes(data);
    }
}

