/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.client;

import com.google.common.base.Supplier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentBlob;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.standby.client.StandbyClient;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StandbyDiff
implements NodeStateDiff {
    private static final Logger log = LoggerFactory.getLogger(StandbyDiff.class);
    private final NodeBuilder builder;
    private final FileStore store;
    private final StandbyClient client;
    private final boolean hasDataStore;
    private final String path;
    private final Supplier<Boolean> running;
    private final boolean logOnly;

    StandbyDiff(NodeBuilder builder, FileStore store, StandbyClient client, Supplier<Boolean> running) {
        this(builder, store, client, "/", false, running);
    }

    private StandbyDiff(NodeBuilder builder, FileStore store, StandbyClient client, String path, boolean logOnly, Supplier<Boolean> running) {
        this.builder = builder;
        this.store = store;
        this.hasDataStore = store.getBlobStore() != null;
        this.client = client;
        this.path = path;
        this.logOnly = logOnly;
        this.running = running;
    }

    private boolean stop() {
        return (Boolean)this.running.get() == false;
    }

    public boolean propertyAdded(PropertyState after) {
        if (this.stop()) {
            return false;
        }
        if (this.logOnly) {
            this.binaryCheck(after);
        } else {
            this.builder.setProperty(this.binaryCheck(after));
        }
        return true;
    }

    public boolean propertyChanged(PropertyState before, PropertyState after) {
        if (this.stop()) {
            return false;
        }
        if (this.logOnly) {
            this.binaryCheck(after);
        } else {
            this.builder.setProperty(this.binaryCheck(after));
        }
        return true;
    }

    public boolean propertyDeleted(PropertyState before) {
        if (this.stop()) {
            return false;
        }
        if (!this.logOnly) {
            this.builder.removeProperty(before.getName());
        }
        return true;
    }

    private PropertyState binaryCheck(PropertyState property) {
        Type type = property.getType();
        if (type == Type.BINARY) {
            this.binaryCheck((Blob)property.getValue(Type.BINARY), property.getName());
        } else if (type == Type.BINARIES) {
            for (Blob blob : (Iterable)property.getValue(Type.BINARIES)) {
                this.binaryCheck(blob, property.getName());
            }
        }
        return property;
    }

    private void binaryCheck(Blob b, String pName) {
        if (b instanceof SegmentBlob) {
            this.binaryCheck((SegmentBlob)b, pName);
        } else {
            log.warn("Unknown Blob {} at {}, ignoring", (Object)b.getClass().getName(), (Object)(this.path + "#" + pName));
        }
    }

    private void binaryCheck(SegmentBlob sb, String pName) {
        if (sb.isExternal() && this.hasDataStore && sb.getReference() == null) {
            String blobId = sb.getBlobId();
            if (blobId == null) {
                return;
            }
            try {
                this.readBlob(blobId, pName);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void readBlob(String blobId, String pName) throws InterruptedException {
        byte[] data = this.client.getBlob(blobId);
        if (data == null) {
            throw new IllegalStateException("Unable to load remote blob " + blobId + " at " + this.path + "#" + pName);
        }
        try {
            this.store.getBlobStore().writeBlob((InputStream)new ByteArrayInputStream(data));
        }
        catch (IOException f) {
            throw new IllegalStateException("Unable to persist blob " + blobId + " at " + this.path + "#" + pName, f);
        }
    }

    public boolean childNodeAdded(String name, NodeState after) {
        return this.process(name, "childNodeAdded", EmptyNodeState.EMPTY_NODE, after);
    }

    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        return this.process(name, "childNodeChanged", before, after);
    }

    private boolean process(String name, String op, NodeState before, NodeState after) {
        if (this.stop()) {
            return false;
        }
        if (after instanceof SegmentNodeState) {
            if (log.isTraceEnabled()) {
                log.trace("{} {}, readonly binary check {}", new Object[]{op, this.path + name, this.logOnly});
            }
            if (!this.logOnly) {
                RecordId id = ((SegmentNodeState)after).getRecordId();
                this.builder.setChildNode(name, (NodeState)this.store.getReader().readNode(id));
            }
            if ("checkpoints".equals(name)) {
                return true;
            }
            if (!this.hasDataStore) {
                return true;
            }
            return after.compareAgainstBaseState(before, (NodeStateDiff)new StandbyDiff(this.builder.getChildNode(name), this.store, this.client, this.path + name + "/", true, this.running));
        }
        return false;
    }

    public boolean childNodeDeleted(String name, NodeState before) {
        log.trace("childNodeDeleted {}, RO:{}", (Object)(this.path + name), (Object)this.logOnly);
        if (!this.logOnly) {
            this.builder.getChildNode(name).remove();
        }
        return true;
    }
}

