/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.client;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentNodeBuilder;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.standby.client.StandbyClient;
import org.apache.jackrabbit.oak.segment.standby.client.StandbyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StandbyClientSyncExecution {
    private static final Logger log = LoggerFactory.getLogger(StandbyClientSyncExecution.class);
    private final FileStore store;
    private final StandbyClient client;
    private final Supplier<Boolean> running;
    private final Map<UUID, Segment> cache = Maps.newHashMap();

    StandbyClientSyncExecution(FileStore store, StandbyClient client, Supplier<Boolean> running) {
        this.store = store;
        this.client = client;
        this.running = running;
    }

    void execute() throws Exception {
        RecordId remoteHead = this.getHead();
        if (remoteHead.equals(this.store.getHead().getRecordId())) {
            return;
        }
        long t = System.currentTimeMillis();
        SegmentNodeState before = this.store.getHead();
        SegmentNodeBuilder builder = before.builder();
        SegmentNodeState current = this.newSegmentNodeState(remoteHead);
        this.compareAgainstBaseState(current, before, builder);
        boolean ok = this.store.getRevisions().setHead(before.getRecordId(), remoteHead, new Revisions.Option[0]);
        this.store.flush();
        log.debug("updated head state successfully: {} in {}ms.", (Object)ok, (Object)(System.currentTimeMillis() - t));
    }

    private RecordId getHead() throws Exception {
        return RecordId.fromString(this.store, this.client.getHead());
    }

    private SegmentNodeState newSegmentNodeState(RecordId id) {
        return this.store.getReader().readNode(id);
    }

    private boolean compareAgainstBaseState(SegmentNodeState current, SegmentNodeState before, SegmentNodeBuilder builder) throws Exception {
        while (true) {
            try {
                return current.compareAgainstBaseState(before, new StandbyDiff((NodeBuilder)builder, this.store, this.client, this.running));
            }
            catch (SegmentNotFoundException e) {
                log.debug("Found missing segment {}", (Object)e.getSegmentId());
                this.copySegmentHierarchyFromPrimary(UUID.fromString(e.getSegmentId()));
                continue;
            }
            break;
        }
    }

    private void copySegmentHierarchyFromPrimary(UUID segmentId) throws Exception {
        LinkedList<UUID> batch = new LinkedList<UUID>();
        batch.offer(segmentId);
        LinkedList<UUID> bulk = new LinkedList<UUID>();
        LinkedList<UUID> data = new LinkedList<UUID>();
        HashSet<UUID> visited = new HashSet<UUID>();
        HashSet<UUID> queued = new HashSet<UUID>();
        HashSet<UUID> local = new HashSet<UUID>();
        while (batch.size() > 0) {
            UUID current = (UUID)batch.remove();
            log.debug("Inspecting segment {}", (Object)current);
            visited.add(current);
            if (!SegmentId.isDataSegmentId(current.getLeastSignificantBits())) {
                bulk.addFirst(current);
                continue;
            }
            data.addFirst(current);
            for (String s : this.readReferences(current)) {
                UUID referenced = UUID.fromString(s);
                if (visited.contains(referenced) || queued.contains(referenced) || local.contains(referenced)) continue;
                if (this.isLocal(referenced)) {
                    local.add(referenced);
                    continue;
                }
                log.debug("Found reference from {} to {}", (Object)current, (Object)referenced);
                batch.add(referenced);
                queued.add(referenced);
            }
        }
        for (UUID id : bulk) {
            log.info("Copying bulk segment {} from primary", (Object)id);
            this.copySegmentFromPrimary(id);
        }
        for (UUID id : data) {
            log.info("Copying data segment {} from primary", (Object)id);
            this.copySegmentFromPrimary(id);
        }
    }

    private Iterable<String> readReferences(UUID id) throws InterruptedException {
        Iterable<String> references = this.client.getReferences(id.toString());
        if (references == null) {
            throw new IllegalStateException(String.format("Unable to read references of segment %s from primary", id));
        }
        return references;
    }

    private boolean isLocal(UUID id) {
        SegmentId referencedId = this.store.newSegmentId(id.getMostSignificantBits(), id.getLeastSignificantBits());
        boolean persisted = true;
        try {
            referencedId.getSegment();
        }
        catch (SegmentNotFoundException e) {
            persisted = false;
        }
        return persisted;
    }

    private void copySegmentFromPrimary(UUID uuid) throws Exception {
        Segment result = this.cache.get(uuid);
        if (result != null) {
            log.debug("Segment {} was found in the local cache", (Object)uuid);
            return;
        }
        byte[] data = this.client.getSegment(uuid.toString());
        if (data == null) {
            throw new IllegalStateException("Unable to read segment " + uuid);
        }
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        SegmentId segmentId = this.store.newSegmentId(msb, lsb);
        this.store.writeSegment(segmentId, data, 0, data.length);
        result = segmentId.getSegment();
        this.cache.put(uuid, result);
    }
}

