/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.memory;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.BinaryReferenceConsumer;
import org.apache.jackrabbit.oak.segment.BinaryReferences;
import org.apache.jackrabbit.oak.segment.CachingSegmentReader;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentIdFactory;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.SegmentTracker;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.SegmentWriterBuilder;
import org.apache.jackrabbit.oak.segment.memory.MemoryStoreRevisions;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

public class MemoryStore
implements SegmentStore {
    @Nonnull
    private final SegmentTracker tracker = new SegmentTracker();
    @Nonnull
    private final MemoryStoreRevisions revisions;
    @Nonnull
    private final SegmentReader segmentReader;
    @Nonnull
    private final SegmentWriter segmentWriter;
    private final SegmentIdFactory segmentIdFactory = new SegmentIdFactory(){

        @Override
        @Nonnull
        public SegmentId newSegmentId(long msb, long lsb) {
            return new SegmentId(MemoryStore.this, msb, lsb);
        }
    };
    private final ConcurrentMap<SegmentId, Segment> segments = Maps.newConcurrentMap();

    public MemoryStore() throws IOException {
        this.revisions = new MemoryStoreRevisions();
        Supplier<SegmentWriter> getWriter = new Supplier<SegmentWriter>(){

            public SegmentWriter get() {
                return MemoryStore.this.getWriter();
            }
        };
        this.segmentReader = new CachingSegmentReader(getWriter, null, 16L, 2L);
        this.segmentWriter = SegmentWriterBuilder.segmentWriterBuilder("sys").withWriterPool().build(this);
        this.revisions.bind(this);
        this.segmentWriter.flush();
    }

    @Nonnull
    public SegmentTracker getTracker() {
        return this.tracker;
    }

    @Nonnull
    public SegmentWriter getWriter() {
        return this.segmentWriter;
    }

    @Nonnull
    public SegmentReader getReader() {
        return this.segmentReader;
    }

    @Nonnull
    public Revisions getRevisions() {
        return this.revisions;
    }

    @Nonnull
    public BinaryReferenceConsumer getBinaryReferenceConsumer() {
        return BinaryReferences.newDiscardBinaryReferenceConsumer();
    }

    @Override
    public boolean containsSegment(SegmentId id) {
        return id.sameStore(this) || this.segments.containsKey(id);
    }

    @Override
    @Nonnull
    public Segment readSegment(SegmentId id) {
        Segment segment = (Segment)this.segments.get(id);
        if (segment != null) {
            return segment;
        }
        throw new SegmentNotFoundException(id);
    }

    @Override
    @Nonnull
    public SegmentId newSegmentId(long msb, long lsb) {
        return this.tracker.newSegmentId(msb, lsb, this.segmentIdFactory);
    }

    @Override
    @Nonnull
    public SegmentId newBulkSegmentId() {
        return this.tracker.newBulkSegmentId(this.segmentIdFactory);
    }

    @Override
    @Nonnull
    public SegmentId newDataSegmentId() {
        return this.tracker.newDataSegmentId(this.segmentIdFactory);
    }

    @Override
    public void writeSegment(SegmentId id, byte[] data, int offset, int length) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buffer.put(data, offset, length);
        buffer.rewind();
        Segment segment = new Segment(this, this.segmentReader, id, buffer);
        if (this.segments.putIfAbsent(id, segment) != null) {
            throw new IOException("Segment override: " + id);
        }
    }

    @CheckForNull
    public BlobStore getBlobStore() {
        return null;
    }

    public void gc() {
        System.gc();
        this.segments.keySet().retainAll(this.tracker.getReferencedSegmentIds());
    }
}

