/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.http;

import com.google.common.base.Supplier;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.BinaryReferenceConsumer;
import org.apache.jackrabbit.oak.segment.BinaryReferences;
import org.apache.jackrabbit.oak.segment.CachingSegmentReader;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentIdFactory;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.SegmentTracker;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.SegmentWriterBuilder;
import org.apache.jackrabbit.oak.segment.http.HttpStoreRevisions;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

public class HttpStore
implements SegmentStore {
    @Nonnull
    private final SegmentTracker tracker = new SegmentTracker();
    @Nonnull
    private final HttpStoreRevisions revisions = new HttpStoreRevisions(this);
    @Nonnull
    private final Supplier<SegmentWriter> getWriter = new Supplier<SegmentWriter>(){

        public SegmentWriter get() {
            return HttpStore.this.getWriter();
        }
    };
    @Nonnull
    private final SegmentReader segmentReader = new CachingSegmentReader(this.getWriter, null, 256L, 64L);
    private final SegmentIdFactory segmentIdFactory = new SegmentIdFactory(){

        @Override
        @Nonnull
        public SegmentId newSegmentId(long msb, long lsb) {
            return new SegmentId(HttpStore.this, msb, lsb);
        }
    };
    @Nonnull
    private final SegmentWriter segmentWriter = SegmentWriterBuilder.segmentWriterBuilder("sys").withWriterPool().build(this);
    private final URL base;

    public HttpStore(URL base) {
        this.base = base;
    }

    @Nonnull
    public SegmentTracker getTracker() {
        return this.tracker;
    }

    @Nonnull
    public SegmentWriter getWriter() {
        return this.segmentWriter;
    }

    @Nonnull
    public SegmentReader getReader() {
        return this.segmentReader;
    }

    @Nonnull
    public Revisions getRevisions() {
        return this.revisions;
    }

    @Nonnull
    public BinaryReferenceConsumer getBinaryReferenceConsumer() {
        return BinaryReferences.newDiscardBinaryReferenceConsumer();
    }

    @Override
    @Nonnull
    public SegmentId newSegmentId(long msb, long lsb) {
        return this.tracker.newSegmentId(msb, lsb, this.segmentIdFactory);
    }

    @Override
    @Nonnull
    public SegmentId newBulkSegmentId() {
        return this.tracker.newBulkSegmentId(this.segmentIdFactory);
    }

    @Override
    @Nonnull
    public SegmentId newDataSegmentId() {
        return this.tracker.newDataSegmentId(this.segmentIdFactory);
    }

    URLConnection get(String fragment) throws MalformedURLException, IOException {
        URL url = fragment == null ? this.base : new URL(this.base, fragment);
        return url.openConnection();
    }

    @Override
    public boolean containsSegment(SegmentId id) {
        return id.sameStore(this) || this.readSegment(id) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Segment readSegment(SegmentId id) {
        Segment segment;
        URLConnection connection = this.get(id.toString());
        InputStream stream = connection.getInputStream();
        try {
            byte[] data = ByteStreams.toByteArray((InputStream)stream);
            segment = new Segment(this, this.segmentReader, id, ByteBuffer.wrap(data));
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (MalformedURLException e) {
                throw new SegmentNotFoundException(id, e);
            }
            catch (IOException e) {
                throw new SegmentNotFoundException(id, e);
            }
        }
        stream.close();
        return segment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSegment(SegmentId id, byte[] bytes, int offset, int length) throws IOException {
        try {
            URLConnection connection = this.get(id.toString());
            connection.setDoInput(false);
            connection.setDoOutput(true);
            try (OutputStream stream = connection.getOutputStream();){
                stream.write(bytes, offset, length);
            }
        }
        catch (MalformedURLException e) {
            throw new IOException(e);
        }
    }

    @CheckForNull
    public BlobStore getBlobStore() {
        return null;
    }
}

