/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tooling;

import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.segment.SegmentBlob;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreBuilders;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.JournalReader;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyChecker
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ConsistencyChecker.class);
    private final FileStore.ReadOnlyStore store;
    private final long debugInterval;
    private int nodeCount;
    private int propertyCount;
    private long ts;

    public static String checkConsistency(File directory, String journalFileName, boolean fullTraversal, long debugInterval, long binLen) throws IOException, InvalidFileStoreVersionException {
        block35: {
            ConsistencyChecker.print("Searching for last good revision in {}", journalFileName);
            HashSet badPaths = Sets.newHashSet();
            try (JournalReader journal = new JournalReader(new File(directory, journalFileName));
                 ConsistencyChecker checker = new ConsistencyChecker(directory, debugInterval);){
                int revisionCount = 0;
                while (true) {
                    String badPath;
                    String revision;
                    block36: {
                        if (!journal.hasNext()) break block35;
                        revision = (String)journal.next();
                        ConsistencyChecker.print("Checking revision {}", revision);
                        ++revisionCount;
                        badPath = checker.check(revision, badPaths, binLen);
                        if (badPath == null && fullTraversal) {
                            badPath = checker.traverse(revision, binLen);
                        }
                        if (badPath != null) break block36;
                        ConsistencyChecker.print("Found latest good revision {}", revision);
                        ConsistencyChecker.print("Searched through {} revisions", revisionCount);
                        String string = revision;
                        return string;
                    }
                    try {
                        badPaths.add(badPath);
                        ConsistencyChecker.print("Broken revision {}", revision);
                    }
                    catch (IllegalArgumentException e) {
                        ConsistencyChecker.print("Skipping invalid record id {}", revision);
                    }
                }
            }
        }
        ConsistencyChecker.print("No good revision found");
        return null;
    }

    public ConsistencyChecker(File directory, long debugInterval) throws IOException, InvalidFileStoreVersionException {
        this.store = FileStoreBuilder.fileStoreBuilder(directory).buildReadOnly();
        this.debugInterval = debugInterval;
    }

    public String check(String revision, Set<String> paths, long binLen) {
        this.store.setRevision(revision);
        for (String path : paths) {
            String err = this.checkPath(path, binLen);
            if (err == null) continue;
            return err;
        }
        return null;
    }

    private String checkPath(String path, long binLen) {
        try {
            ConsistencyChecker.print("Checking {}", path);
            NodeState root = SegmentNodeStoreBuilders.builder(this.store).build().getRoot();
            String parentPath = PathUtils.getParentPath((String)path);
            String name = PathUtils.getName((String)path);
            NodeState parent = NodeStateUtils.getNode((NodeState)root, (String)parentPath);
            if (!PathUtils.denotesRoot((String)path) && parent.hasChildNode(name)) {
                return this.traverse(parent.getChildNode(name), path, false, binLen);
            }
            return this.traverse(parent, parentPath, false, binLen);
        }
        catch (RuntimeException e) {
            ConsistencyChecker.print("Error while checking {}: {}", path, e.getMessage());
            return path;
        }
    }

    public String traverse(String revision, long binLen) {
        try {
            this.store.setRevision(revision);
            this.nodeCount = 0;
            this.propertyCount = 0;
            String result = this.traverse(SegmentNodeStoreBuilders.builder(this.store).build().getRoot(), "/", true, binLen);
            ConsistencyChecker.print("Traversed {} nodes and {} properties", this.nodeCount, this.propertyCount);
            return result;
        }
        catch (RuntimeException e) {
            ConsistencyChecker.print("Error while traversing {}", revision, e.getMessage());
            return "/";
        }
    }

    private String traverse(NodeState node, String path, boolean deep, long binLen) {
        try {
            this.debug("Traversing {}", path);
            ++this.nodeCount;
            for (PropertyState propertyState : node.getProperties()) {
                this.debug("Checking {}/{}", path, propertyState);
                Type type = propertyState.getType();
                if (type == Type.BINARY) {
                    ConsistencyChecker.traverse((Blob)propertyState.getValue(Type.BINARY), binLen);
                } else if (type == Type.BINARIES) {
                    for (Blob blob : (Iterable)propertyState.getValue(Type.BINARIES)) {
                        ConsistencyChecker.traverse(blob, binLen);
                    }
                } else {
                    propertyState.getValue(type);
                }
                ++this.propertyCount;
            }
            for (ChildNodeEntry cne : node.getChildNodeEntries()) {
                String result;
                String childName = cne.getName();
                NodeState child = cne.getNodeState();
                if (!deep || (result = this.traverse(child, PathUtils.concat((String)path, (String)childName), true, binLen)) == null) continue;
                return result;
            }
            return null;
        }
        catch (RuntimeException e) {
            ConsistencyChecker.print("Error while traversing {}: {}", path, e.getMessage());
            return path;
        }
        catch (IOException e) {
            ConsistencyChecker.print("Error while traversing {}: {}", path, e.getMessage());
            return path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traverse(Blob blob, long length) throws IOException {
        if (length < 0L) {
            length = Long.MAX_VALUE;
        }
        if (length > 0L && !ConsistencyChecker.isExternal(blob)) {
            try (InputStream s = blob.getNewStream();){
                byte[] buffer = new byte[8192];
                int l = s.read(buffer, 0, (int)Math.min((long)buffer.length, length));
                while (l >= 0 && (length -= (long)l) > 0L) {
                    l = s.read(buffer, 0, (int)Math.min((long)buffer.length, length));
                }
            }
        }
    }

    private static boolean isExternal(Blob b) {
        if (b instanceof SegmentBlob) {
            return ((SegmentBlob)b).isExternal();
        }
        return false;
    }

    @Override
    public void close() {
        this.store.close();
    }

    private static void print(String format) {
        LOG.info(format);
    }

    private static void print(String format, Object arg) {
        LOG.info(format, arg);
    }

    private static void print(String format, Object arg1, Object arg2) {
        LOG.info(format, arg1, arg2);
    }

    private void debug(String format, Object arg) {
        if (this.debug()) {
            LOG.debug(format, arg);
        }
    }

    private void debug(String format, Object arg1, Object arg2) {
        if (this.debug()) {
            LOG.debug(format, arg1, arg2);
        }
    }

    private boolean debug() {
        if (this.debugInterval == Long.MAX_VALUE) {
            return false;
        }
        if (this.debugInterval == 0L) {
            return true;
        }
        long ts = System.currentTimeMillis();
        if ((ts - this.ts) / 1000L > this.debugInterval) {
            this.ts = ts;
            return true;
        }
        return false;
    }
}

