/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.GCEstimation;
import org.apache.jackrabbit.oak.segment.file.GCJournal;

public class SizeDeltaGcEstimation
implements GCEstimation {
    private final long delta;
    private final GCJournal gcJournal;
    private final long totalSize;
    private boolean gcNeeded;
    private String gcInfo = "unknown";
    private boolean finished = false;

    public SizeDeltaGcEstimation(@Nonnull SegmentGCOptions opts, @Nonnull GCJournal gcJournal, long totalSize) {
        this.delta = ((SegmentGCOptions)Preconditions.checkNotNull((Object)opts)).getGcSizeDeltaEstimation();
        this.gcJournal = (GCJournal)Preconditions.checkNotNull((Object)gcJournal);
        this.totalSize = totalSize;
    }

    @Override
    public boolean gcNeeded() {
        if (!this.finished) {
            this.run();
        }
        return this.gcNeeded;
    }

    @Override
    public String gcLog() {
        if (!this.finished) {
            this.run();
        }
        return this.gcInfo;
    }

    private void run() {
        if (this.finished) {
            return;
        }
        if (this.delta == 0L) {
            this.gcNeeded = true;
            this.gcInfo = String.format("Estimation skipped because the size delta value equals 0", this.delta);
        } else if (this.getPreviousCleanupSize() < 0L) {
            this.gcNeeded = true;
            this.gcInfo = String.format("Estimation skipped because of missing gc journal data", new Object[0]);
        } else {
            long lastGc = this.getPreviousCleanupSize();
            long gain = this.totalSize - lastGc;
            long gainP = 100L * (this.totalSize - lastGc) / this.totalSize;
            this.gcNeeded = gain > this.delta;
            this.gcInfo = this.gcNeeded ? String.format("Size delta is %s%% or %s/%s (%s/%s bytes), so running compaction", gainP, IOUtils.humanReadableByteCount((long)lastGc), IOUtils.humanReadableByteCount((long)this.totalSize), lastGc, this.totalSize) : String.format("Size delta is %s%% or %s/%s (%s/%s bytes), so skipping compaction for now", gainP, IOUtils.humanReadableByteCount((long)lastGc), IOUtils.humanReadableByteCount((long)this.totalSize), lastGc, this.totalSize);
        }
        this.finished = true;
    }

    private long getPreviousCleanupSize() {
        return this.gcJournal.read().getRepoSize();
    }
}

