/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheStats;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class PriorityCache<K, V> {
    private final int rehash;
    private final Entry<?, ?>[] entries;
    private final int[] costs = new int[256];
    private final int[] evictions = new int[256];
    private long hitCount;
    private long missCount;
    private long loadCount;
    private long evictionCount;
    private long size;

    public static <K, V> Supplier<PriorityCache<K, V>> factory(final int size) {
        Preconditions.checkArgument((Integer.bitCount(size) == 1 ? 1 : 0) != 0);
        return new Supplier<PriorityCache<K, V>>(){

            public PriorityCache<K, V> get() {
                return new PriorityCache(size);
            }
        };
    }

    public PriorityCache(int size, int rehash) {
        Preconditions.checkArgument((Integer.bitCount(size) == 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((rehash >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((rehash < 32 - Integer.numberOfTrailingZeros(size) ? 1 : 0) != 0);
        this.rehash = rehash;
        this.entries = new Entry[size];
        Arrays.fill(this.entries, Entry.NULL);
    }

    public PriorityCache(int size) {
        this(size, 31 - Integer.numberOfTrailingZeros(size));
    }

    private int project(int hashCode, int iteration) {
        return hashCode >> iteration & this.entries.length - 1;
    }

    public long size() {
        return this.size;
    }

    public synchronized boolean put(@Nonnull K key, @Nonnull V value, int generation, byte initialCost) {
        int hashCode = key.hashCode();
        byte cheapest = initialCost;
        int index = -1;
        boolean eviction = false;
        for (int k = 0; k <= this.rehash; ++k) {
            int i = this.project(hashCode, k);
            Entry<?, ?> entry = this.entries[i];
            if (entry == Entry.NULL) {
                index = i;
                break;
            }
            if (entry.generation <= generation && key.equals(entry.key)) {
                index = i;
                initialCost = entry.cost;
                if (initialCost >= 127) break;
                initialCost = (byte)(initialCost + 1);
                break;
            }
            if (entry.generation < generation) {
                index = i;
                break;
            }
            if (entry.cost >= cheapest) continue;
            cheapest = entry.cost;
            index = i;
            eviction = true;
        }
        if (index >= 0) {
            Entry<?, ?> old = this.entries[index];
            this.entries[index] = new Entry<K, V>(key, value, generation, initialCost);
            ++this.loadCount;
            int n = initialCost - -128;
            this.costs[n] = this.costs[n] + 1;
            if (old != Entry.NULL) {
                int n2 = old.cost - -128;
                this.costs[n2] = this.costs[n2] - 1;
                if (eviction) {
                    int n3 = old.cost - -128;
                    this.evictions[n3] = this.evictions[n3] + 1;
                    ++this.evictionCount;
                }
            } else {
                ++this.size;
            }
            return true;
        }
        return false;
    }

    @CheckForNull
    public synchronized V get(@Nonnull K key, int generation) {
        int hashCode = key.hashCode();
        for (int k = 0; k <= this.rehash; ++k) {
            int i = this.project(hashCode, k);
            Entry<?, ?> entry = this.entries[i];
            if (generation != entry.generation || !key.equals(entry.key)) continue;
            if (entry.cost < 127) {
                int n = entry.cost - -128;
                this.costs[n] = this.costs[n] - 1;
                entry.cost = (byte)(entry.cost + 1);
                int n2 = entry.cost - -128;
                this.costs[n2] = this.costs[n2] + 1;
            }
            ++this.hitCount;
            return entry.value;
        }
        ++this.missCount;
        return null;
    }

    public synchronized void purgeGenerations(@Nonnull Predicate<Integer> purge) {
        for (int i = 0; i < this.entries.length; ++i) {
            Entry<?, ?> entry = this.entries[i];
            if (entry == Entry.NULL || !purge.apply((Object)entry.generation)) continue;
            this.entries[i] = Entry.NULL;
            --this.size;
        }
    }

    public synchronized String toString() {
        return "PriorityCache{ costs=" + PriorityCache.toString(this.costs) + ", evictions=" + PriorityCache.toString(this.evictions) + " }";
    }

    private static String toString(int[] ints) {
        StringBuilder b = new StringBuilder("[");
        String sep = "";
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] <= 0) continue;
            b.append(sep).append(i).append("->").append(ints[i]);
            sep = ",";
        }
        return b.append(']').toString();
    }

    @Nonnull
    public CacheStats getStats() {
        return new CacheStats(this.hitCount, this.missCount, this.loadCount, 0L, 0L, this.evictionCount);
    }

    private static class Entry<K, V> {
        static Entry<Void, Void> NULL = new Entry<Object, Object>(null, null, -1, -128);
        final K key;
        final V value;
        final int generation;
        byte cost;

        public Entry(K key, V value, int generation, byte cost) {
            this.key = key;
            this.value = value;
            this.generation = generation;
            this.cost = cost;
        }

        public String toString() {
            return this == NULL ? "NULL" : "Entry{" + this.key + "->" + this.value + " @" + this.generation + ", $" + this.cost + "}";
        }
    }
}

