/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

class Manifest {
    private static final String STORE_VERSION = "store.version";
    private final Properties properties;

    static Manifest load(File file) throws IOException {
        Properties properties = new Properties();
        properties.load(new FileReader(file));
        return new Manifest(properties);
    }

    static Manifest empty() {
        return new Manifest(new Properties());
    }

    private Manifest(Properties properties) {
        this.properties = properties;
    }

    int getStoreVersion(int otherwise) {
        return this.getIntegerProperty(STORE_VERSION, otherwise);
    }

    void setStoreVersion(int version) {
        this.setIntegerProperty(STORE_VERSION, version);
    }

    void save(File file) throws IOException {
        this.properties.store(new FileWriter(file), null);
    }

    private int getIntegerProperty(String name, int otherwise) {
        Object value = this.properties.get(name);
        if (value == null) {
            return otherwise;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException e) {
            return otherwise;
        }
    }

    private void setIntegerProperty(String name, int value) {
        this.properties.put(name, Integer.toString(value));
    }
}

