/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.RecordCache;
import org.apache.jackrabbit.oak.segment.WriterCacheManager;
import org.apache.jackrabbit.oak.segment.compaction.LoggingGCMonitor;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.GCListener;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.PriorityCache;
import org.apache.jackrabbit.oak.segment.file.TarRevisions;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.gc.DelegatingGCMonitor;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(FileStore.class);
    @Nonnull
    private final File directory;
    @CheckForNull
    private BlobStore blobStore;
    private int maxFileSize = 256;
    private int segmentCacheSize = 256;
    private int stringCacheSize = 256;
    private int templateCacheSize = 64;
    private int stringDeduplicationCacheSize = WriterCacheManager.DEFAULT_STRING_CACHE_SIZE;
    private int templateDeduplicationCacheSize = WriterCacheManager.DEFAULT_TEMPLATE_CACHE_SIZE;
    private int nodeDeduplicationCacheSize = WriterCacheManager.DEFAULT_NODE_CACHE_SIZE;
    private boolean memoryMapping = FileStore.MEMORY_MAPPING_DEFAULT;
    @Nonnull
    private StatisticsProvider statsProvider = StatisticsProvider.NOOP;
    @Nonnull
    private SegmentGCOptions gcOptions = SegmentGCOptions.defaultGCOptions();
    @Nonnull
    private final DelegatingGCMonitor gcMonitor = new DelegatingGCMonitor();
    @CheckForNull
    private EvictingWriteCacheManager cacheManager;
    @Nonnull
    private final GCListener gcListener = new GCListener(){

        public void info(String message, Object ... arguments) {
            FileStoreBuilder.this.gcMonitor.info(message, arguments);
        }

        public void warn(String message, Object ... arguments) {
            FileStoreBuilder.this.gcMonitor.warn(message, arguments);
        }

        public void error(String message, Exception exception) {
            FileStoreBuilder.this.gcMonitor.error(message, exception);
        }

        public void skipped(String reason, Object ... arguments) {
            FileStoreBuilder.this.gcMonitor.skipped(reason, arguments);
        }

        public void compacted(long[] segmentCounts, long[] recordCounts, long[] compactionMapWeights) {
            FileStoreBuilder.this.gcMonitor.compacted(segmentCounts, recordCounts, compactionMapWeights);
        }

        public void cleaned(long reclaimedSize, long currentSize) {
            FileStoreBuilder.this.gcMonitor.cleaned(reclaimedSize, currentSize);
        }

        @Override
        public void compacted(@Nonnull GCListener.Status status, int newGeneration) {
            Preconditions.checkNotNull((Object)FileStoreBuilder.this.cacheManager);
            switch (status) {
                case SUCCESS: {
                    FileStoreBuilder.this.gcMonitor.compacted(new long[0], new long[0], new long[0]);
                    FileStoreBuilder.this.cacheManager.evictOldGeneration(newGeneration);
                    break;
                }
                case FAILURE: {
                    FileStoreBuilder.this.cacheManager.evictGeneration(newGeneration);
                }
            }
        }
    };
    @CheckForNull
    private TarRevisions revisions;

    @Nonnull
    public static FileStoreBuilder fileStoreBuilder(@Nonnull File directory) {
        return new FileStoreBuilder(directory);
    }

    private FileStoreBuilder(@Nonnull File directory) {
        this.directory = (File)Preconditions.checkNotNull((Object)directory);
        this.gcMonitor.registerGCMonitor((GCMonitor)new LoggingGCMonitor(LOG));
    }

    @Nonnull
    public FileStoreBuilder withBlobStore(@Nonnull BlobStore blobStore) {
        this.blobStore = (BlobStore)Preconditions.checkNotNull((Object)blobStore);
        return this;
    }

    @Nonnull
    public FileStoreBuilder withMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
        return this;
    }

    @Nonnull
    public FileStoreBuilder withSegmentCacheSize(int segmentCacheSize) {
        this.segmentCacheSize = segmentCacheSize;
        return this;
    }

    @Nonnull
    public FileStoreBuilder withStringCacheSize(int stringCacheSize) {
        this.stringCacheSize = stringCacheSize;
        return this;
    }

    @Nonnull
    public FileStoreBuilder withTemplateCacheSize(int templateCacheSize) {
        this.templateCacheSize = templateCacheSize;
        return this;
    }

    @Nonnull
    public FileStoreBuilder withStringDeduplicationCacheSize(int stringDeduplicationCacheSize) {
        this.stringDeduplicationCacheSize = stringDeduplicationCacheSize;
        return this;
    }

    @Nonnull
    public FileStoreBuilder withTemplateDeduplicationCacheSize(int templateDeduplicationCacheSize) {
        this.templateDeduplicationCacheSize = templateDeduplicationCacheSize;
        return this;
    }

    @Nonnull
    public FileStoreBuilder withNodeDeduplicationCacheSize(int nodeDeduplicationCacheSize) {
        this.nodeDeduplicationCacheSize = nodeDeduplicationCacheSize;
        return this;
    }

    @Nonnull
    public FileStoreBuilder withMemoryMapping(boolean memoryMapping) {
        this.memoryMapping = memoryMapping;
        return this;
    }

    @Nonnull
    public FileStoreBuilder withDefaultMemoryMapping() {
        this.memoryMapping = FileStore.MEMORY_MAPPING_DEFAULT;
        return this;
    }

    @Nonnull
    public FileStoreBuilder withGCMonitor(@Nonnull GCMonitor gcMonitor) {
        this.gcMonitor.registerGCMonitor((GCMonitor)Preconditions.checkNotNull((Object)gcMonitor));
        return this;
    }

    @Nonnull
    public FileStoreBuilder withStatisticsProvider(@Nonnull StatisticsProvider statisticsProvider) {
        this.statsProvider = (StatisticsProvider)Preconditions.checkNotNull((Object)statisticsProvider);
        return this;
    }

    @Nonnull
    public FileStoreBuilder withGCOptions(SegmentGCOptions gcOptions) {
        this.gcOptions = (SegmentGCOptions)Preconditions.checkNotNull((Object)gcOptions);
        return this;
    }

    @Nonnull
    public FileStore build() throws InvalidFileStoreVersionException, IOException {
        Preconditions.checkState((this.revisions == null ? 1 : 0) != 0, (Object)"Cannot re-use builder");
        this.directory.mkdirs();
        this.revisions = new TarRevisions(false, this.directory);
        LOG.info("Creating file store {}", (Object)this);
        return new FileStore(this, false).bind(this.revisions);
    }

    @Nonnull
    public FileStore.ReadOnlyStore buildReadOnly() throws InvalidFileStoreVersionException, IOException {
        Preconditions.checkState((this.revisions == null ? 1 : 0) != 0, (Object)"Cannot re-use builder");
        Preconditions.checkState((this.directory.exists() && this.directory.isDirectory() ? 1 : 0) != 0);
        this.revisions = new TarRevisions(true, this.directory);
        LOG.info("Creating file store {}", (Object)this);
        return new FileStore.ReadOnlyStore(this).bind(this.revisions);
    }

    @Nonnull
    File getDirectory() {
        return this.directory;
    }

    @CheckForNull
    BlobStore getBlobStore() {
        return this.blobStore;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    int getSegmentCacheSize() {
        return this.segmentCacheSize;
    }

    int getStringCacheSize() {
        return this.stringCacheSize;
    }

    int getTemplateCacheSize() {
        return this.templateCacheSize;
    }

    boolean getMemoryMapping() {
        return this.memoryMapping;
    }

    @Nonnull
    GCListener getGcListener() {
        return this.gcListener;
    }

    @Nonnull
    StatisticsProvider getStatsProvider() {
        return this.statsProvider;
    }

    @Nonnull
    SegmentGCOptions getGcOptions() {
        return this.gcOptions;
    }

    @Nonnull
    TarRevisions getRevisions() {
        Preconditions.checkState((this.revisions != null ? 1 : 0) != 0, (Object)"File store not yet built");
        return this.revisions;
    }

    @Nonnull
    WriterCacheManager getCacheManager() {
        if (this.cacheManager == null) {
            this.cacheManager = new EvictingWriteCacheManager(this.stringDeduplicationCacheSize, this.templateDeduplicationCacheSize, this.nodeDeduplicationCacheSize);
        }
        return this.cacheManager;
    }

    public String toString() {
        return "FileStoreBuilder{directory=" + this.directory + ", blobStore=" + this.blobStore + ", maxFileSize=" + this.maxFileSize + ", segmentCacheSize=" + this.segmentCacheSize + ", stringCacheSize=" + this.stringCacheSize + ", templateCacheSize=" + this.templateCacheSize + ", stringDeduplicationCacheSize=" + this.stringDeduplicationCacheSize + ", templateDeduplicationCacheSize=" + this.templateDeduplicationCacheSize + ", nodeDeduplicationCacheSize=" + this.nodeDeduplicationCacheSize + ", memoryMapping=" + this.memoryMapping + ", gcOptions=" + this.gcOptions + '}';
    }

    private static class EvictingWriteCacheManager
    extends WriterCacheManager.Default {
        public EvictingWriteCacheManager(int stringCacheSize, int templateCacheSize, int nodeCacheSize) {
            super(RecordCache.factory(stringCacheSize), RecordCache.factory(templateCacheSize), PriorityCache.factory(nodeCacheSize));
        }

        void evictOldGeneration(final int newGeneration) {
            this.evictCaches(new Predicate<Integer>(){

                public boolean apply(Integer generation) {
                    return generation < newGeneration;
                }
            });
        }

        void evictGeneration(final int newGeneration) {
            this.evictCaches(new Predicate<Integer>(){

                public boolean apply(Integer generation) {
                    return generation == newGeneration;
                }
            });
        }
    }
}

