/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.compaction;

import com.google.common.base.Preconditions;

public class SegmentGCOptions {
    public static final boolean PAUSE_DEFAULT = false;
    public static final byte GAIN_THRESHOLD_DEFAULT = 10;
    public static final int RETRY_COUNT_DEFAULT = 5;
    public static final int FORCE_TIMEOUT_DEFAULT = 60;
    public static final int RETAINED_GENERATIONS_DEFAULT = 2;
    public static final long SIZE_DELTA_ESTIMATION_DEFAULT = -1L;
    private boolean paused = false;
    private int gainThreshold = 10;
    private int retryCount = 5;
    private int forceTimeout = 60;
    private int retainedGenerations = 2;
    private boolean offline = false;
    private boolean ocBinDeduplication = Boolean.getBoolean("oak.segment.compaction.binaryDeduplication");
    private long ocBinMaxSize = Long.getLong("oak.segment.compaction.binaryDeduplicationMaxSize", 0x6400000L);
    private long gcSizeDeltaEstimation = Long.getLong("oak.segment.compaction.gcSizeDeltaEstimation", -1L);
    private volatile boolean stopCompaction;

    public SegmentGCOptions(boolean paused, int gainThreshold, int retryCount, int forceTimeout) {
        this.paused = paused;
        this.gainThreshold = gainThreshold;
        this.retryCount = retryCount;
        this.forceTimeout = forceTimeout;
    }

    public SegmentGCOptions() {
        this(false, 10, 5, 60);
    }

    public static SegmentGCOptions defaultGCOptions() {
        return new SegmentGCOptions();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public SegmentGCOptions setPaused(boolean paused) {
        this.paused = paused;
        return this;
    }

    public int getGainThreshold() {
        return this.gainThreshold;
    }

    public SegmentGCOptions setGainThreshold(int gainThreshold) {
        this.gainThreshold = gainThreshold;
        return this;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public SegmentGCOptions setRetryCount(int retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    public int getForceTimeout() {
        return this.forceTimeout;
    }

    public SegmentGCOptions setForceTimeout(int timeout) {
        this.forceTimeout = timeout;
        return this;
    }

    public int getRetainedGenerations() {
        return this.retainedGenerations;
    }

    public SegmentGCOptions setRetainedGenerations(int retainedGenerations) {
        Preconditions.checkArgument((retainedGenerations > 1 ? 1 : 0) != 0, (String)"RetainedGenerations must not be below 2. Got %s", (Object[])new Object[]{retainedGenerations});
        this.retainedGenerations = retainedGenerations;
        return this;
    }

    public String toString() {
        if (this.offline) {
            return this.getClass().getSimpleName() + "{" + "offline=" + this.offline + ", retainedGenerations=" + this.retainedGenerations + ", ocBinDeduplication=" + this.ocBinDeduplication + ", ocBinMaxSize=" + this.ocBinMaxSize + "}";
        }
        return this.getClass().getSimpleName() + "{" + "paused=" + this.paused + ", gainThreshold=" + this.gainThreshold + ", retryCount=" + this.retryCount + ", forceTimeout=" + this.forceTimeout + ", retainedGenerations=" + this.retainedGenerations + ", gcSizeDeltaEstimation=" + this.gcSizeDeltaEstimation + "}";
    }

    public boolean isDiskSpaceSufficient(long repositoryDiskSpace, long availableDiskSpace) {
        return (double)availableDiskSpace > 0.25 * (double)repositoryDiskSpace;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public SegmentGCOptions setOffline() {
        this.offline = true;
        this.retainedGenerations = 1;
        return this;
    }

    public SegmentGCOptions withBinaryDeduplication() {
        this.ocBinDeduplication = true;
        return this;
    }

    public boolean isBinaryDeduplication() {
        return this.ocBinDeduplication;
    }

    public SegmentGCOptions setBinaryDeduplicationMaxSize(long binMaxSize) {
        this.ocBinMaxSize = binMaxSize;
        return this;
    }

    public long getBinaryDeduplicationMaxSize() {
        return this.ocBinMaxSize;
    }

    public boolean isGcSizeDeltaEstimation() {
        return this.gcSizeDeltaEstimation >= 0L;
    }

    public long getGcSizeDeltaEstimation() {
        return this.gcSizeDeltaEstimation;
    }

    public SegmentGCOptions setGcSizeDeltaEstimation(long gcSizeDeltaEstimation) {
        this.gcSizeDeltaEstimation = gcSizeDeltaEstimation;
        return this;
    }

    public boolean isStopCompaction() {
        return this.stopCompaction;
    }

    public boolean setStopCompaction(boolean stop) {
        this.stopCompaction = stop;
        return stop;
    }
}

