/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.segment.ReaderCache;
import org.apache.jackrabbit.oak.segment.Template;

public class TemplateCache
extends ReaderCache<Template> {
    TemplateCache(long maxSize) {
        super(maxSize, 250, "Template Cache");
    }

    @Override
    protected int getEntryWeight(Template template) {
        int size = 168;
        size += 40;
        size += TemplateCache.estimateMemoryUsage(template.getPrimaryType());
        size += TemplateCache.estimateMemoryUsage(template.getMixinTypes());
        size += TemplateCache.estimateMemoryUsage(template.getChildName());
        for (PropertyTemplate property : template.getPropertyTemplates()) {
            size += TemplateCache.estimateMemoryUsage(property);
        }
        return size;
    }

    private static int estimateMemoryUsage(PropertyTemplate propertyTemplate) {
        return 4 + TemplateCache.estimateMemoryUsage(propertyTemplate.getName());
    }

    private static int estimateMemoryUsage(PropertyState propertyState) {
        if (propertyState == null) {
            return 0;
        }
        int size = TemplateCache.estimateMemoryUsage(propertyState.getName());
        for (int k = 0; k < propertyState.count(); ++k) {
            size += TemplateCache.estimateMemoryUsage((String)propertyState.getValue(Type.STRING, k));
        }
        return size;
    }

    private static int estimateMemoryUsage(String string) {
        if (string == null) {
            return 0;
        }
        return StringUtils.estimateMemoryUsage((String)string);
    }

    @Override
    protected boolean isSmall(Template template) {
        PropertyTemplate[] properties = template.getPropertyTemplates();
        PropertyState mixins = template.getMixinTypes();
        return properties.length == 0 && (mixins == null || mixins.count() == 0);
    }
}

