/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.segment.ReaderCache;

public class StringCache
extends ReaderCache<String> {
    private static final int MAX_STRING_SIZE = 128;

    StringCache(long maxSize) {
        super(maxSize, 250, "String Cache");
    }

    @Override
    protected int getEntryWeight(String string) {
        int size = 168;
        size += 40;
        return size += StringUtils.estimateMemoryUsage((String)string);
    }

    @Override
    protected boolean isSmall(String string) {
        return string.length() <= 128;
    }
}

