/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.primitives.UnsignedBytes;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;

public enum SegmentVersion {
    V_10(10),
    V_11(11),
    V_12(12);

    public static final SegmentVersion LATEST_VERSION;
    private final byte version;

    private SegmentVersion(byte version) {
        this.version = version;
    }

    public boolean onOrAfter(SegmentVersion other) {
        return this.compareTo(other) >= 0;
    }

    public static byte asByte(SegmentVersion v) {
        return v.version;
    }

    public static SegmentVersion fromByte(byte v) {
        if (v == SegmentVersion.V_12.version) {
            return V_12;
        }
        if (v == SegmentVersion.V_11.version) {
            return V_11;
        }
        if (v == SegmentVersion.V_10.version) {
            return V_10;
        }
        throw new IllegalArgumentException("Unknown version " + v);
    }

    public static boolean isValid(byte v) {
        return v == SegmentVersion.V_12.version;
    }

    public static boolean isValid(SegmentVersion version) {
        return SegmentVersion.isValid(version.version);
    }

    static {
        LATEST_VERSION = Collections.max(EnumSet.allOf(SegmentVersion.class), new Comparator<SegmentVersion>(){

            @Override
            public int compare(SegmentVersion v1, SegmentVersion v2) {
                return UnsignedBytes.compare((byte)v1.version, (byte)v2.version);
            }
        });
    }
}

