/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.segment.BlockRecord;
import org.apache.jackrabbit.oak.segment.ListRecord;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentStore;

public class SegmentStream
extends InputStream {
    private final RecordId recordId;
    private final byte[] inline;
    private final ListRecord blocks;
    private final long length;
    private long position = 0L;
    private long mark = 0L;

    @CheckForNull
    public static RecordId getRecordIdIfAvailable(InputStream stream, SegmentStore store) {
        if (stream instanceof SegmentStream) {
            SegmentStream sstream = (SegmentStream)stream;
            RecordId id = sstream.recordId;
            if (sstream.position == 0L && id.getSegmentId().sameStore(store)) {
                return id;
            }
        }
        return null;
    }

    SegmentStream(RecordId recordId, ListRecord blocks, long length) {
        this.recordId = (RecordId)Preconditions.checkNotNull((Object)recordId);
        this.inline = null;
        this.blocks = (ListRecord)Preconditions.checkNotNull((Object)blocks);
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0);
        this.length = length;
    }

    SegmentStream(RecordId recordId, byte[] inline) {
        this.recordId = (RecordId)Preconditions.checkNotNull((Object)recordId);
        this.inline = (byte[])Preconditions.checkNotNull((Object)inline);
        this.blocks = null;
        this.length = inline.length;
    }

    List<RecordId> getBlockIds() {
        if (this.blocks == null) {
            return null;
        }
        return this.blocks.getEntries();
    }

    public long getLength() {
        return this.length;
    }

    public String getString() {
        if (this.inline != null) {
            return new String(this.inline, Charsets.UTF_8);
        }
        if (this.length > Integer.MAX_VALUE) {
            throw new IllegalStateException("Too long value: " + this.length);
        }
        try (SegmentStream stream = new SegmentStream(this.recordId, this.blocks, this.length);){
            byte[] data = new byte[(int)this.length];
            ByteStreams.readFully((InputStream)stream, (byte[])data);
            String string = new String(data, Charsets.UTF_8);
            return string;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.position;
    }

    @Override
    public synchronized void reset() {
        this.position = this.mark;
    }

    @Override
    public int read() {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) != -1) {
            return b[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        Preconditions.checkNotNull((Object)b);
        Preconditions.checkPositionIndexes((int)off, (int)(off + len), (int)b.length);
        if (len == 0) {
            return 0;
        }
        if (this.position == this.length) {
            return -1;
        }
        if (this.position + (long)len > this.length) {
            len = (int)(this.length - this.position);
        }
        if (this.inline != null) {
            System.arraycopy(this.inline, (int)this.position, b, off, len);
        } else {
            int blockIndex = (int)(this.position / 4096L);
            int blockOffset = (int)(this.position % 4096L);
            int blockCount = (blockOffset + len + 4096 - 1) / 4096;
            int remaining = len;
            List<RecordId> ids = this.blocks.getEntries(blockIndex, blockCount);
            RecordId first = ids.get(0);
            int count = 1;
            for (int i = 1; i <= ids.size(); ++i) {
                int n;
                RecordId id = null;
                if (i < ids.size()) {
                    id = ids.get(i);
                }
                if (id != null && id.getSegmentId().equals(first.getSegmentId()) && id.getRecordNumber() == first.getRecordNumber() + count * 4096) {
                    ++count;
                    continue;
                }
                int blockSize = Math.min(blockOffset + remaining, count * 4096);
                BlockRecord block = new BlockRecord(first, blockSize);
                Preconditions.checkState((block.read(blockOffset, b, off, n = blockSize - blockOffset) == n ? 1 : 0) != 0);
                off += n;
                remaining -= n;
                first = id;
                count = 1;
                blockOffset = 0;
            }
            Preconditions.checkState((remaining == 0 ? 1 : 0) != 0);
        }
        this.position += (long)len;
        return len;
    }

    @Override
    public long skip(long n) {
        if (this.position + n > this.length) {
            n = this.length - this.position;
        } else if (this.position + n < 0L) {
            n = -this.position;
        }
        this.position += n;
        return n;
    }

    @Override
    public int available() {
        if (this.inline != null) {
            return (int)(this.length - this.position);
        }
        return 0;
    }

    @Override
    public void close() {
        this.position = this.length;
    }
}

