/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.commons.SimpleValueFactory;
import org.apache.jackrabbit.oak.api.Descriptors;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.api.jmx.CheckpointMBean;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.ObserverTracker;
import org.apache.jackrabbit.oak.osgi.OsgiUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.blob.BlobGC;
import org.apache.jackrabbit.oak.plugins.blob.BlobGCMBean;
import org.apache.jackrabbit.oak.plugins.blob.BlobGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.BlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.blob.BlobTrackingStore;
import org.apache.jackrabbit.oak.plugins.blob.MarkSweepGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.BlobIdTracker;
import org.apache.jackrabbit.oak.plugins.blob.datastore.BlobTracker;
import org.apache.jackrabbit.oak.plugins.blob.datastore.SharedDataStoreUtils;
import org.apache.jackrabbit.oak.plugins.identifier.ClusterRepositoryInfo;
import org.apache.jackrabbit.oak.segment.SegmentBlobReferenceRetriever;
import org.apache.jackrabbit.oak.segment.SegmentCheckpointMBean;
import org.apache.jackrabbit.oak.segment.SegmentDiscoveryLiteDescriptors;
import org.apache.jackrabbit.oak.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreBuilders;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.SegmentStoreProvider;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.compaction.SegmentRevisionGC;
import org.apache.jackrabbit.oak.segment.compaction.SegmentRevisionGCMBean;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.FileStoreGCMonitor;
import org.apache.jackrabbit.oak.segment.file.FileStoreStatsMBean;
import org.apache.jackrabbit.oak.segment.file.GCMonitorMBean;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.gc.GCMonitorTracker;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.ProxyNodeStore;
import org.apache.jackrabbit.oak.spi.state.RevisionGC;
import org.apache.jackrabbit.oak.spi.state.RevisionGCMBean;
import org.apache.jackrabbit.oak.spi.whiteboard.CompositeRegistration;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardExecutor;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.util.GenericDescriptors;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE, metatype=true, label="Apache Jackrabbit Oak Segment NodeStore Service", description="NodeStore implementation based on Segment model. For configuration option refer to http://jackrabbit.apache.org/oak/docs/osgi_config.html#SegmentNodeStore. Note that for system stability purpose it is advisable to not change these settings at runtime. Instead the config change should be done via file system based config file and this view should ONLY be used to determine which options are supported")
public class SegmentNodeStoreService
extends ProxyNodeStore
implements Observable,
SegmentStoreProvider {
    public static final String NAME = "name";
    @Property(label="Directory", description="Directory location used to store the segment tar files. If not specified then looks for framework property 'repository.home' otherwise use a subdirectory with name 'tarmk'")
    public static final String DIRECTORY = "repository.home";
    @Property(label="Mode", description="TarMK mode (64 for memory mapping, 32 for normal file access)")
    public static final String MODE = "tarmk.mode";
    @Property(intValue={256}, label="Maximum Tar File Size (MB)", description="TarMK maximum file size (MB)")
    public static final String SIZE = "tarmk.size";
    @Property(intValue={256}, label="Segment cache size (MB)", description="Cache size for storing most recently used segments")
    public static final String SEGMENT_CACHE_SIZE = "segmentCache.size";
    @Property(intValue={256}, label="String cache size (MB)", description="Cache size for storing most recently used strings")
    public static final String STRING_CACHE_SIZE = "stringCache.size";
    @Property(intValue={64}, label="Template cache size (MB)", description="Cache size for storing most recently used templates")
    public static final String TEMPLATE_CACHE_SIZE = "templateCache.size";
    @Property(intValue={15000}, label="String deduplication cache size (#items)", description="Maximum number of strings to keep in the deduplication cache")
    public static final String STRING_DEDUPLICATION_CACHE_SIZE = "stringDeduplicationCache.size";
    @Property(intValue={3000}, label="Template deduplication cache size (#items)", description="Maximum number of templates to keep in the deduplication cache")
    public static final String TEMPLATE_DEDUPLICATION_CACHE_SIZE = "templateDeduplicationCache.size";
    @Property(intValue={0x800000}, label="Node deduplication cache size (#items)", description="Maximum number of node to keep in the deduplication cache. If the supplied value is not a power of 2, it will be rounded up to the next power of 2.")
    public static final String NODE_DEDUPLICATION_CACHE_SIZE = "nodeDeduplicationCache.size";
    @Property(byteValue={10}, label="Compaction gain threshold", description="TarMK compaction gain threshold. The gain estimation prevents compaction from running if the provided threshold is not met. Value represents a percentage so an input between 0 and 100 is expected.")
    public static final String COMPACTION_GAIN_THRESHOLD = "compaction.gainThreshold";
    @Property(boolValue={false}, label="Pause Compaction", description="When enabled compaction would not be performed")
    public static final String PAUSE_COMPACTION = "pauseCompaction";
    @Property(intValue={5}, label="Compaction Retries", description="Number of tries to compact concurrent commits on top of already compacted commits")
    public static final String COMPACTION_RETRY_COUNT = "compaction.retryCount";
    @Property(intValue={60}, label="Force Compaction Timeout", description="Number of seconds to attempt to force compact concurrent commits on top of already compacted commits after the maximum number of retries has been reached. Forced compaction tries to acquire an exclusive write lock on the node store.")
    public static final String COMPACTION_FORCE_TIMEOUT = "compaction.force.timeout";
    @Property(longValue={-1L}, label="Compaction Repository Size Delta", description="Amount of increase in repository size that will trigger compaction (bytes)")
    public static final String COMPACTION_SIZE_DELTA_ESTIMATION = "compaction.sizeDeltaEstimation";
    @Property(boolValue={false}, label="Standby Mode", description="Flag indicating that this component will not register as a NodeStore but just as a NodeStoreProvider")
    public static final String STANDBY = "standby";
    @Property(boolValue={false}, label="Custom BlobStore", description="Boolean value indicating that a custom BlobStore is to be used. By default large binary content would be stored within segment tar files")
    public static final String CUSTOM_BLOB_STORE = "customBlobStore";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String name;
    private FileStore store;
    private volatile SegmentNodeStore segmentNodeStore;
    private ObserverTracker observerTracker;
    private GCMonitorTracker gcMonitor;
    private ComponentContext context;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, target="(&(!(split.blobstore=old))(!(split.blobstore=new)))")
    private volatile BlobStore blobStore;
    @Reference
    private StatisticsProvider statisticsProvider = StatisticsProvider.NOOP;
    private ServiceRegistration storeRegistration;
    private ServiceRegistration providerRegistration;
    private final List<Registration> registrations = new ArrayList<Registration>();
    private WhiteboardExecutor executor;
    private boolean customBlobStore;
    private static final long DEFAULT_BLOB_GC_MAX_AGE = 86400L;
    @Property(longValue={86400L}, label="Blob GC Max Age (in secs)", description="Blob Garbage Collector (GC) logic will only consider those blobs for GC which are not accessed recently (currentTime - lastModifiedTime > blobGcMaxAgeInSecs). For example as per default only those blobs which have been created 24 hrs ago will be considered for GC")
    public static final String PROP_BLOB_GC_MAX_AGE = "blobGcMaxAgeInSecs";
    private static final long DEFAULT_BLOB_SNAPSHOT_INTERVAL = 43200L;
    @Property(longValue={43200L}, label="Blob tracking snapshot interval (in secs)", description="This is the default interval in which the snapshots of locally tracked blob ids willbe taken and synchronized with the blob store")
    public static final String PROP_BLOB_SNAPSHOT_INTERVAL = "blobTrackSnapshotIntervalInSecs";

    protected SegmentNodeStore getNodeStore() {
        Preconditions.checkState((this.segmentNodeStore != null ? 1 : 0) != 0, (Object)"service must be activated when used");
        return this.segmentNodeStore;
    }

    @Activate
    public void activate(ComponentContext context) throws IOException {
        this.context = context;
        this.customBlobStore = Boolean.parseBoolean(this.property(CUSTOM_BLOB_STORE));
        if (this.blobStore == null && this.customBlobStore) {
            this.log.info("BlobStore use enabled. SegmentNodeStore would be initialized when BlobStore would be available");
        } else {
            this.registerNodeStore();
        }
    }

    protected void bindBlobStore(BlobStore blobStore) throws IOException {
        this.blobStore = blobStore;
        this.registerNodeStore();
    }

    protected void unbindBlobStore(BlobStore blobStore) {
        this.blobStore = null;
        this.unregisterNodeStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    public void deactivate() {
        this.unregisterNodeStore();
        SegmentNodeStoreService segmentNodeStoreService = this;
        synchronized (segmentNodeStoreService) {
            if (this.observerTracker != null) {
                this.observerTracker.stop();
            }
            if (this.gcMonitor != null) {
                this.gcMonitor.stop();
            }
            this.segmentNodeStore = null;
            if (this.store != null) {
                this.store.close();
                this.store = null;
            }
        }
    }

    private synchronized void registerNodeStore() throws IOException {
        if (this.registerSegmentStore()) {
            if (PropertiesUtil.toBoolean((Object)this.property(STANDBY), (boolean)false)) {
                return;
            }
            if (this.registerSegmentNodeStore()) {
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("service.pid", SegmentNodeStore.class.getName());
                ((Dictionary)props).put("oak.nodestore.description", new String[]{"nodeStoreType=segment"});
                this.storeRegistration = this.context.getBundleContext().registerService(NodeStore.class.getName(), (Object)this, props);
            }
        }
    }

    private boolean registerSegmentStore() throws IOException {
        CacheStatsMBean nodeDeduplicationCacheStats;
        CacheStatsMBean templateDeduplicationCacheStats;
        if (this.context == null) {
            this.log.info("Component still not activated. Ignoring the initialization call");
            return false;
        }
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(this.context.getBundleContext());
        this.gcMonitor = new GCMonitorTracker();
        this.gcMonitor.start((Whiteboard)whiteboard);
        SegmentGCOptions gcOptions = this.newGCOptions();
        FileStoreBuilder builder = FileStoreBuilder.fileStoreBuilder(this.getDirectory()).withSegmentCacheSize(this.getSegmentCacheSize()).withStringCacheSize(this.getStringCacheSize()).withTemplateCacheSize(this.getTemplateCacheSize()).withStringDeduplicationCacheSize(this.getStringDeduplicationCacheSize()).withTemplateDeduplicationCacheSize(this.getTemplateDeduplicationCacheSize()).withNodeDeduplicationCacheSize(this.getNodeDeduplicationCacheSize()).withMaxFileSize(this.getMaxFileSize()).withMemoryMapping(this.getMode().equals("64")).withGCMonitor((GCMonitor)this.gcMonitor).withStatisticsProvider(this.statisticsProvider).withGCOptions(gcOptions);
        if (this.customBlobStore) {
            this.log.info("Initializing SegmentNodeStore with BlobStore [{}]", (Object)this.blobStore);
            builder.withBlobStore(this.blobStore);
        }
        try {
            this.store = builder.build();
        }
        catch (InvalidFileStoreVersionException e) {
            this.log.error("The segment store data is not compatible with the current version. Please use oak-segment or a different version of oak-segment-tar.");
            return false;
        }
        this.registrations.add(WhiteboardUtils.registerMBean((Whiteboard)whiteboard, SegmentRevisionGC.class, (Object)new SegmentRevisionGCMBean(gcOptions), (String)"SegmentRevisionGarbageCollection", (String)"Segment node store gc options"));
        CacheStatsMBean segmentCacheStats = this.store.getSegmentCacheStats();
        this.registrations.add(WhiteboardUtils.registerMBean((Whiteboard)whiteboard, CacheStatsMBean.class, (Object)segmentCacheStats, (String)"CacheStats", (String)segmentCacheStats.getName()));
        CacheStatsMBean stringCacheStats = this.store.getStringCacheStats();
        this.registrations.add(WhiteboardUtils.registerMBean((Whiteboard)whiteboard, CacheStatsMBean.class, (Object)stringCacheStats, (String)"CacheStats", (String)stringCacheStats.getName()));
        CacheStatsMBean templateCacheStats = this.store.getTemplateCacheStats();
        this.registrations.add(WhiteboardUtils.registerMBean((Whiteboard)whiteboard, CacheStatsMBean.class, (Object)templateCacheStats, (String)"CacheStats", (String)templateCacheStats.getName()));
        CacheStatsMBean stringDeduplicationCacheStats = this.store.getStringDeduplicationCacheStats();
        if (stringDeduplicationCacheStats != null) {
            this.registrations.add(WhiteboardUtils.registerMBean((Whiteboard)whiteboard, CacheStatsMBean.class, (Object)stringDeduplicationCacheStats, (String)"CacheStats", (String)stringDeduplicationCacheStats.getName()));
        }
        if ((templateDeduplicationCacheStats = this.store.getTemplateDeduplicationCacheStats()) != null) {
            this.registrations.add(WhiteboardUtils.registerMBean((Whiteboard)whiteboard, CacheStatsMBean.class, (Object)templateDeduplicationCacheStats, (String)"CacheStats", (String)templateDeduplicationCacheStats.getName()));
        }
        if ((nodeDeduplicationCacheStats = this.store.getNodeDeduplicationCacheStats()) != null) {
            this.registrations.add(WhiteboardUtils.registerMBean((Whiteboard)whiteboard, CacheStatsMBean.class, (Object)nodeDeduplicationCacheStats, (String)"CacheStats", (String)nodeDeduplicationCacheStats.getName()));
        }
        this.executor = new WhiteboardExecutor();
        this.executor.start((Whiteboard)whiteboard);
        this.registrations.add(WhiteboardUtils.registerMBean((Whiteboard)whiteboard, RevisionGCMBean.class, (Object)new RevisionGC(this.store.getGCRunner(), (Executor)this.executor), (String)"RevisionGarbageCollection", (String)"Segment node store revision garbage collection"));
        this.registrations.add(WhiteboardUtils.registerMBean((Whiteboard)whiteboard, FileStoreStatsMBean.class, (Object)this.store.getStats(), (String)"FileStoreStats", (String)"FileStore statistics"));
        FileStoreGCMonitor fsgcm = new FileStoreGCMonitor(Clock.SIMPLE);
        this.registrations.add((Registration)new CompositeRegistration(new Registration[]{whiteboard.register(GCMonitor.class, (Object)fsgcm, Collections.emptyMap()), WhiteboardUtils.registerMBean((Whiteboard)whiteboard, GCMonitorMBean.class, (Object)fsgcm, (String)"GC Monitor", (String)"File Store garbage collection monitor")}));
        this.providerRegistration = this.context.getBundleContext().registerService(SegmentStoreProvider.class.getName(), (Object)this, null);
        return true;
    }

    private SegmentGCOptions newGCOptions() {
        boolean pauseCompaction = PropertiesUtil.toBoolean((Object)this.property(PAUSE_COMPACTION), (boolean)false);
        int retryCount = PropertiesUtil.toInteger((Object)this.property(COMPACTION_RETRY_COUNT), (int)5);
        int forceTimeout = PropertiesUtil.toInteger((Object)this.property(COMPACTION_FORCE_TIMEOUT), (int)60);
        byte gainThreshold = this.getGainThreshold();
        long sizeDeltaEstimation = PropertiesUtil.toLong((Object)this.property(COMPACTION_SIZE_DELTA_ESTIMATION), (long)-1L);
        return new SegmentGCOptions(pauseCompaction, gainThreshold, retryCount, forceTimeout).setGcSizeDeltaEstimation(sizeDeltaEstimation);
    }

    private boolean registerSegmentNodeStore() throws IOException {
        Dictionary properties = this.context.getProperties();
        this.name = String.valueOf(properties.get(NAME));
        long blobGcMaxAgeInSecs = PropertiesUtil.toLong((Object)this.property(PROP_BLOB_GC_MAX_AGE), (long)86400L);
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(this.context.getBundleContext());
        this.segmentNodeStore = SegmentNodeStoreBuilders.builder(this.store).build();
        this.observerTracker = new ObserverTracker((Observable)this.segmentNodeStore);
        this.observerTracker.start(this.context.getBundleContext());
        this.registrations.add(WhiteboardUtils.registerMBean((Whiteboard)whiteboard, CheckpointMBean.class, (Object)((Object)new SegmentCheckpointMBean(this.segmentNodeStore)), (String)"CheckpointManger", (String)"Segment node store checkpoint management"));
        GenericDescriptors clusterIdDesc = new GenericDescriptors();
        clusterIdDesc.put("oak.clusterid", new SimpleValueFactory().createValue(ClusterRepositoryInfo.getOrCreateId((NodeStore)this.segmentNodeStore)), true, false);
        this.registrations.add(whiteboard.register(Descriptors.class, (Object)clusterIdDesc, Collections.emptyMap()));
        this.registrations.add(whiteboard.register(Descriptors.class, (Object)new SegmentDiscoveryLiteDescriptors(this.segmentNodeStore), Collections.emptyMap()));
        String repoId = "";
        if (SharedDataStoreUtils.isShared((BlobStore)this.blobStore)) {
            try {
                repoId = ClusterRepositoryInfo.getOrCreateId((NodeStore)this.segmentNodeStore);
                ((SharedDataStore)this.blobStore).addMetadataRecord((InputStream)new ByteArrayInputStream(new byte[0]), SharedDataStoreUtils.SharedStoreRecordType.REPOSITORY.getNameFromId(repoId));
            }
            catch (Exception e) {
                throw new IOException("Could not register a unique repositoryId", e);
            }
            if (this.blobStore instanceof BlobTrackingStore) {
                BlobTrackingStore trackingStore;
                long trackSnapshotInterval = PropertiesUtil.toLong((Object)this.property(PROP_BLOB_SNAPSHOT_INTERVAL), (long)43200L);
                String root = this.property(DIRECTORY);
                if (Strings.isNullOrEmpty((String)root)) {
                    root = "repository";
                }
                if ((trackingStore = (BlobTrackingStore)this.blobStore).getTracker() != null) {
                    trackingStore.getTracker().close();
                }
                ((BlobTrackingStore)this.blobStore).addTracker((BlobTracker)new BlobIdTracker(root, repoId, trackSnapshotInterval, (SharedDataStore)this.blobStore));
            }
        }
        if (this.store.getBlobStore() instanceof GarbageCollectableBlobStore) {
            MarkSweepGarbageCollector gc = new MarkSweepGarbageCollector((BlobReferenceRetriever)new SegmentBlobReferenceRetriever(this.store), (GarbageCollectableBlobStore)this.store.getBlobStore(), (Executor)this.executor, TimeUnit.SECONDS.toMillis(blobGcMaxAgeInSecs), repoId);
            this.registrations.add(WhiteboardUtils.registerMBean((Whiteboard)whiteboard, BlobGCMBean.class, (Object)new BlobGC((BlobGarbageCollector)gc, (Executor)this.executor), (String)"BlobGarbageCollection", (String)"Segment node store blob garbage collection"));
        }
        this.log.info("SegmentNodeStore initialized");
        return true;
    }

    private void unregisterNodeStore() {
        new CompositeRegistration(this.registrations).unregister();
        if (this.providerRegistration != null) {
            this.providerRegistration.unregister();
            this.providerRegistration = null;
        }
        if (this.storeRegistration != null) {
            this.storeRegistration.unregister();
            this.storeRegistration = null;
        }
        if (this.executor != null) {
            this.executor.stop();
            this.executor = null;
        }
    }

    private File getBaseDirectory() {
        String directory = this.property(DIRECTORY);
        if (directory != null) {
            return new File(directory);
        }
        return new File("tarmk");
    }

    private File getDirectory() {
        return new File(this.getBaseDirectory(), "segmentstore");
    }

    private String getMode() {
        String mode = this.property(MODE);
        if (mode != null) {
            return mode;
        }
        return System.getProperty(MODE, System.getProperty("sun.arch.data.model", "32"));
    }

    private String getCacheSize(String propertyName) {
        String cacheSize = this.property(propertyName);
        if (cacheSize != null) {
            return cacheSize;
        }
        return System.getProperty(propertyName);
    }

    private int getSegmentCacheSize() {
        return Integer.parseInt(this.getCacheSize(SEGMENT_CACHE_SIZE));
    }

    private int getStringCacheSize() {
        return Integer.parseInt(this.getCacheSize(STRING_CACHE_SIZE));
    }

    private int getTemplateCacheSize() {
        return Integer.parseInt(this.getCacheSize(TEMPLATE_CACHE_SIZE));
    }

    private int getStringDeduplicationCacheSize() {
        return Integer.parseInt(this.getCacheSize(STRING_DEDUPLICATION_CACHE_SIZE));
    }

    private int getTemplateDeduplicationCacheSize() {
        return Integer.parseInt(this.getCacheSize(TEMPLATE_DEDUPLICATION_CACHE_SIZE));
    }

    private int getNodeDeduplicationCacheSize() {
        int size = Math.max(1, Integer.parseInt(this.getCacheSize(NODE_DEDUPLICATION_CACHE_SIZE)));
        return 1 << 32 - Integer.numberOfLeadingZeros(size - 1);
    }

    private String getMaxFileSizeProperty() {
        String size = this.property(SIZE);
        if (size != null) {
            return size;
        }
        return System.getProperty(SIZE, "256");
    }

    private int getMaxFileSize() {
        return Integer.parseInt(this.getMaxFileSizeProperty());
    }

    private byte getGainThreshold() {
        String gt = this.property(COMPACTION_GAIN_THRESHOLD);
        if (gt == null) {
            return 10;
        }
        return Byte.valueOf(gt);
    }

    private String property(String name) {
        return OsgiUtil.lookupConfigurationThenFramework((ComponentContext)this.context, (String)name);
    }

    @Override
    public SegmentStore getSegmentStore() {
        return this.store;
    }

    public Closeable addObserver(Observer observer) {
        return this.getNodeStore().addObserver(observer);
    }

    public String toString() {
        return this.name + ": " + this.segmentNodeStore;
    }

    protected void bindStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    protected void unbindStatisticsProvider(StatisticsProvider statisticsProvider) {
        if (this.statisticsProvider == statisticsProvider) {
            this.statisticsProvider = null;
        }
    }
}

