/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentId
implements Comparable<SegmentId> {
    private static final Logger log = LoggerFactory.getLogger(SegmentId.class);
    @Nonnull
    private final SegmentStore store;
    private final long msb;
    private final long lsb;
    private final long creationTime;
    private int gcGeneration = -1;
    @CheckForNull
    private String gcInfo;
    private volatile Segment segment;

    public static boolean isDataSegmentId(long lsb) {
        return lsb >>> 60 == 10L;
    }

    public SegmentId(@Nonnull SegmentStore store, long msb, long lsb) {
        this.store = store;
        this.msb = msb;
        this.lsb = lsb;
        this.creationTime = System.currentTimeMillis();
    }

    public boolean isDataSegmentId() {
        return SegmentId.isDataSegmentId(this.lsb);
    }

    public boolean isBulkSegmentId() {
        return this.lsb >>> 60 == 11L;
    }

    public long getMostSignificantBits() {
        return this.msb;
    }

    public long getLeastSignificantBits() {
        return this.lsb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Segment getSegment() {
        Segment segment = this.segment;
        if (segment == null) {
            SegmentId segmentId = this;
            synchronized (segmentId) {
                segment = this.segment;
                if (segment == null) {
                    try {
                        log.debug("Loading segment {}", (Object)this);
                        segment = this.store.readSegment(this);
                        this.gcGeneration = segment.getGcGeneration();
                        this.segment = segment;
                    }
                    catch (SegmentNotFoundException snfe) {
                        log.error("Segment not found: {}. {}", new Object[]{this, this.gcInfo(), snfe});
                        throw snfe;
                    }
                }
            }
        }
        return segment;
    }

    @Nonnull
    private String gcInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("SegmentId age=").append(System.currentTimeMillis() - this.creationTime).append("ms");
        if (this.gcInfo != null) {
            sb.append(",").append(this.gcInfo);
        }
        if (this.gcGeneration >= 0) {
            sb.append(",").append("segment-generation=").append(this.gcGeneration);
        }
        return sb.toString();
    }

    @CheckForNull
    String getGcInfo() {
        return this.gcInfo;
    }

    public void reclaimed(@Nonnull String gcInfo) {
        this.gcInfo = gcInfo;
    }

    void loaded(@Nonnull Segment segment) {
        this.segment = segment;
        this.gcGeneration = segment.getGcGeneration();
    }

    void unloaded() {
        this.segment = null;
    }

    public boolean sameStore(@Nonnull SegmentStore store) {
        return this.store == store;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public UUID asUUID() {
        return new UUID(this.msb, this.lsb);
    }

    public int getGcGeneration() {
        if (this.gcGeneration < 0) {
            this.getSegment();
        }
        return this.gcGeneration;
    }

    @Override
    public int compareTo(SegmentId that) {
        int d = Long.valueOf(this.msb).compareTo(that.msb);
        if (d == 0) {
            d = Long.valueOf(this.lsb).compareTo(that.lsb);
        }
        return d;
    }

    public String toString() {
        return new UUID(this.msb, this.lsb).toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SegmentId) {
            SegmentId that = (SegmentId)object;
            return this.msb == that.msb && this.lsb == that.lsb;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.lsb;
    }
}

