/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.cache.RemovalCause;
import com.google.common.cache.Weigher;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.cache.CacheLIRS;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;

public class SegmentCache {
    public static final int DEFAULT_SEGMENT_CACHE_MB = 256;
    private final Weigher<SegmentId, Segment> weigher = new Weigher<SegmentId, Segment>(){

        public int weigh(SegmentId id, Segment segment) {
            return 224 + segment.size();
        }
    };
    @Nonnull
    private final CacheLIRS<SegmentId, Segment> cache;

    public SegmentCache(long cacheSizeMB) {
        this.cache = CacheLIRS.newBuilder().module("SegmentCache").maximumWeight(cacheSizeMB * 1024L * 1024L).averageWeight(131072).weigher(this.weigher).evictionCallback((CacheLIRS.EvictionCallback)new CacheLIRS.EvictionCallback<SegmentId, Segment>(){

            public void evicted(SegmentId id, Segment segment, RemovalCause cause) {
                if (segment != null) {
                    id.unloaded();
                }
            }
        }).build();
    }

    @Nonnull
    public Segment getSegment(@Nonnull SegmentId id, @Nonnull Callable<Segment> loader) throws ExecutionException {
        return (Segment)this.cache.get((Object)id, loader);
    }

    public void putSegment(@Nonnull Segment segment) {
        this.cache.put((Object)segment.getSegmentId(), (Object)segment);
        segment.getSegmentId().loaded(segment);
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    @Nonnull
    public CacheStats getCacheStats() {
        return new CacheStats(this.cache, "Segment Cache", this.weigher, this.cache.getMaxMemory());
    }
}

